/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.archetype;

import iskallia.vault.client.ClientArchetypeData;
import iskallia.vault.skill.archetype.AbstractArchetypeConfig;
import iskallia.vault.world.data.PlayerArchetypeData;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractArchetype<C extends AbstractArchetypeConfig>
extends ForgeRegistryEntry<AbstractArchetype<?>> {
    protected final Supplier<C> configSupplier;
    protected final String name;

    protected AbstractArchetype(Supplier<C> configSupplier, ResourceLocation id) {
        this.configSupplier = configSupplier;
        this.name = "archetype." + id.m_135827_() + "." + id.m_135815_();
        this.setRegistryName(id);
    }

    public C getConfig() {
        return (C)((AbstractArchetypeConfig)this.configSupplier.get());
    }

    public String getName() {
        return this.name;
    }

    public boolean hasThisArchetype(LivingEntity entity) {
        if (entity instanceof Player && entity.m_20194_() == null) {
            return ClientArchetypeData.getCurrentArchetype() == this;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return PlayerArchetypeData.get(player.f_8924_).getArchetypeContainer((Player)player).getCurrentArchetype() == this;
        }
        return false;
    }

    public void onAdded(MinecraftServer server, ServerPlayer player) {
    }

    public void onTick(MinecraftServer server, ServerPlayer player) {
    }

    public void onRemoved(MinecraftServer server, ServerPlayer player) {
    }
}

