/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.base;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;

public class GroupedSkill
extends LearnableSkill {
    private List<LearnableSkill> children;
    private int selected;
    private int maxSpentLearnPoints;
    private static final ArrayAdapter<Skill> SPECIALIZATIONS = Adapters.ofArray(Skill[]::new, Adapters.SKILL);

    public GroupedSkill(int unlockLevel, int learnPointCost, int regretPointCost, Stream<LearnableSkill> children, int maxSpentLearnPoints) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.children = children.toList();
        this.children.forEach(specialization -> specialization.setParent(this));
        this.maxSpentLearnPoints = maxSpentLearnPoints;
    }

    public GroupedSkill() {
    }

    public List<LearnableSkill> getChildren() {
        return this.children;
    }

    public int getMaxSpentLearnPoints() {
        return this.maxSpentLearnPoints;
    }

    @Override
    public int getUnlockLevel() {
        return this.children.get(this.selected).getUnlockLevel();
    }

    @Override
    public int getLearnPointCost() {
        return this.children.get(this.selected).getLearnPointCost();
    }

    @Override
    public int getRegretPointCost() {
        return this.children.get(this.selected).getRegretPointCost();
    }

    @Override
    public boolean isUnlocked() {
        return this.children.stream().anyMatch(Skill::isUnlocked);
    }

    @Override
    public int getSpentLearnPoints() {
        int points = 0;
        for (LearnableSkill child : this.children) {
            points += child.getSpentLearnPoints();
        }
        return points;
    }

    @Override
    public boolean canLearn(SkillContext context) {
        int previous = context.getLearnPoints();
        context.setLearnPoints(Math.min(previous, this.maxSpentLearnPoints - this.getSpentLearnPoints()));
        boolean result = this.children.get(this.selected).canLearn(context);
        context.setLearnPoints(previous);
        return result;
    }

    @Override
    public void learn(SkillContext context) {
        this.children.get(this.selected).learn(context);
    }

    @Override
    public boolean canRegret(SkillContext context) {
        return this.children.get(this.selected).canRegret(context);
    }

    @Override
    public void regret(SkillContext context) {
        this.children.get(this.selected).regret(context);
    }

    public void select(String id) {
        for (int i = 0; i < this.children.size(); ++i) {
            LearnableSkill child = this.children.get(i);
            if (!child.getId().equals(id)) continue;
            this.selected = i;
            break;
        }
    }

    @Override
    public Optional<Skill> getForId(String id) {
        return super.getForId(id).or(() -> {
            for (Skill skill : this.children) {
                Skill skill2 = skill.getForId(id).orElse(null);
                if (skill2 == null) continue;
                return Optional.of(skill2);
            }
            return Optional.empty();
        });
    }

    @Override
    public <T> void iterate(Class<T> type, Consumer<T> action) {
        super.iterate(type, action);
        for (LearnableSkill child : this.children) {
            child.iterate(type, action);
        }
    }

    @Override
    public Skill mergeFrom(Skill other, SkillContext context) {
        super.mergeFrom(other, context);
        if (!(other instanceof GroupedSkill)) {
            context.setLearnPoints(context.getLearnPoints() + this.getSpentLearnPoints());
            return other.copy();
        }
        GroupedSkill grouped = (GroupedSkill)other;
        ArrayList<LearnableSkill> copy = new ArrayList<LearnableSkill>();
        HashSet<String> removed = new HashSet<String>(this.children.stream().map(Skill::getId).filter(Objects::nonNull).toList());
        for (LearnableSkill child : grouped.children) {
            removed.remove(child.getId());
            Skill merging = this.getForId(child.getId()).orElse(null);
            Skill merged = merging != null ? merging.mergeFrom(child, context) : child.copy();
            if (!(merged instanceof LearnableSkill)) continue;
            merged.setParent(this);
            copy.add((LearnableSkill)merged);
        }
        this.children = copy;
        int newIndex = grouped.selected;
        this.selected = newIndex < 0 || newIndex >= copy.size() ? 0 : newIndex;
        for (String id : removed) {
            this.getForId(id).ifPresent(skill -> {
                if (skill instanceof LearnableSkill) {
                    LearnableSkill learnable = (LearnableSkill)skill;
                    context.setLearnPoints(context.getLearnPoints() + learnable.getLearnPointCost());
                }
            });
        }
        this.maxSpentLearnPoints = grouped.maxSpentLearnPoints;
        if (this.getSpentLearnPoints() > this.maxSpentLearnPoints) {
            context.setLearnPoints(context.getLearnPoints() + this.getSpentLearnPoints());
            return grouped.copy();
        }
        return this;
    }

    @Override
    public <T extends Skill> T copy() {
        GroupedSkill copy = new GroupedSkill(this.getUnlockLevel(), this.getLearnPointCost(), this.getRegretPointCost(), this.children.stream().map(Skill::copy), this.maxSpentLearnPoints);
        copy.parent = this.parent;
        copy.id = this.id;
        copy.name = this.name;
        copy.present = this.present;
        copy.learnPointCost = this.learnPointCost;
        copy.regretPointCost = this.regretPointCost;
        copy.unlockLevel = this.unlockLevel;
        copy.selected = this.selected;
        return (T)copy;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        SPECIALIZATIONS.writeBits((Skill)((Skill[])this.children.toArray(Skill[]::new)), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.selected, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.maxSpentLearnPoints, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.children = Arrays.stream((Skill[])SPECIALIZATIONS.readBits(buffer).orElseThrow()).map(skill -> (LearnableSkill)skill).toList();
        this.selected = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.maxSpentLearnPoints = Adapters.INT_SEGMENTED_3.readBits(buffer).orElse(0);
        this.children.forEach(specialization -> specialization.setParent(this));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            SPECIALIZATIONS.writeNbt((Skill)((Skill[])this.children.toArray(Skill[]::new))).ifPresent(tag -> nbt.m_128365_("children", tag));
            Adapters.INT.writeNbt(this.selected).ifPresent(tag -> nbt.m_128365_("selected", tag));
            Adapters.INT.writeNbt(this.maxSpentLearnPoints).ifPresent(tag -> nbt.m_128365_("maxSpentLearnPoints", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.children = Arrays.stream((Skill[])SPECIALIZATIONS.readNbt(nbt.m_128423_("children")).orElseThrow()).map(skill -> (LearnableSkill)skill).toList();
        this.selected = Adapters.INT.readNbt(nbt.m_128423_("selected")).orElse(0);
        this.maxSpentLearnPoints = Adapters.INT.readNbt(nbt.m_128423_("maxSpentLearnPoints")).orElse(0);
        this.children.forEach(child -> child.setParent(this));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            SPECIALIZATIONS.writeJson((Skill)((Skill[])this.children.toArray(Skill[]::new))).ifPresent(element -> json.add("children", element));
            Adapters.INT.writeJson(this.selected).ifPresent(element -> json.add("selected", element));
            Adapters.INT.writeJson(this.maxSpentLearnPoints).ifPresent(element -> json.add("maxSpentLearnPoints", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.children = Arrays.stream((Skill[])SPECIALIZATIONS.readJson(json.get("children")).orElseThrow()).map(skill -> (LearnableSkill)skill).toList();
        this.selected = Adapters.INT.readJson(json.get("selected")).orElse(0);
        this.maxSpentLearnPoints = Adapters.INT.readJson(json.get("maxSpentLearnPoints")).orElse(0);
        this.children.forEach(child -> child.setParent(this));
    }
}

