/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.expertise.type;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.ability.effect.ManaShieldAbility;
import iskallia.vault.skill.ability.effect.spi.core.ToggleAbilityEffect;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.util.VHSmpUtil;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class AngelExpertise
extends LearnableSkill
implements TickingSkill {
    private static final String ANGEL_DISABLED_TAG = VaultMod.sId("angel_disabled");

    public AngelExpertise(int unlockLevel, int learnPointCost, int regretPointCost) {
        super(unlockLevel, learnPointCost, regretPointCost);
    }

    public AngelExpertise() {
    }

    public static void toggleAngel(ServerPlayer player) {
        if (player.m_19880_().contains(ANGEL_DISABLED_TAG)) {
            player.m_19880_().remove(ANGEL_DISABLED_TAG);
        } else {
            player.m_19880_().add(ANGEL_DISABLED_TAG);
        }
    }

    private boolean isAngelSwitchedOff(Player player) {
        return player.m_19880_().contains(ANGEL_DISABLED_TAG);
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(Player.class).ifPresent(player -> {
            if (!player.m_5833_() && !player.m_7500_()) {
                AngelExpertise.removeCreativeFlight(player);
                player.m_6885_();
            }
        });
    }

    private static void removeCreativeFlight(Player player) {
        player.m_150110_().f_35936_ = false;
        player.m_150110_().f_35935_ = false;
        player.m_21195_((MobEffect)ModEffects.ANGEL);
    }

    private static void giveCreativeFlight(Player player) {
        player.m_150110_().f_35936_ = true;
        ModEffects.ANGEL.addTo((LivingEntity)player, 0);
    }

    @Override
    public void onTick(SkillContext context) {
        if (!this.isUnlocked()) {
            return;
        }
        context.getSource().as(Player.class).ifPresent(player -> {
            if (!player.m_5833_() && !player.m_7500_() && (ServerVaults.get(player.f_19853_).isPresent() || this.isAngelSwitchedOff((Player)player) || VHSmpUtil.isArenaWorld(player.f_19853_) || !ModBlocks.ANGEL_BLOCK.isInRange((Player)player))) {
                if (player.m_150110_().f_35936_ && player.m_150110_().f_35935_) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100));
                }
                AngelExpertise.removeCreativeFlight(player);
            } else if (!player.m_150110_().f_35936_) {
                AngelExpertise.giveCreativeFlight(player);
            }
            player.m_6885_();
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt();
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson();
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
    }

    public static class AngelEffect
    extends ToggleAbilityEffect {
        public AngelEffect(int color, ResourceLocation resourceLocation) {
            super(ManaShieldAbility.class, color, resourceLocation);
        }
    }
}

