/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent;

import iskallia.vault.skill.talent.LegacyTalent;
import iskallia.vault.skill.talent.TalentGroup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraftforge.common.util.INBTSerializable;

public class TalentNode<T extends LegacyTalent>
implements INBTSerializable<CompoundTag> {
    private TalentGroup<T> group;
    private int level;

    public TalentNode(TalentGroup<T> group, int level) {
        this.group = group;
        this.level = Mth.m_14045_((int)level, (int)0, (int)group.getMaxLevel());
    }

    public TalentNode(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public TalentGroup<T> getGroup() {
        return this.group;
    }

    public int getLevel() {
        return this.level;
    }

    public T getTalent() {
        if (!this.isLearned()) {
            return null;
        }
        return this.getGroup().getTalent(this.getLevel());
    }

    public String getName() {
        return this.getGroup().getName(this.getLevel());
    }

    public boolean isLearned() {
        return this.getLevel() > 0;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Name", this.getGroup().getParentName());
        nbt.m_128405_("Level", this.getLevel());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        String groupName = nbt.m_128461_("Name");
        this.level = nbt.m_128451_("Level");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TalentNode that = (TalentNode)other;
        return this.level == that.level && this.group.getParentName().equals(that.group.getParentName());
    }
}

