/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.health;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.talent.GearAttributeSkill;
import iskallia.vault.skill.talent.type.health.HighHealthTalent;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class HighHealthGearAttributeTalent
extends HighHealthTalent
implements GearAttributeSkill,
TickingSkill {
    private VaultGearAttribute<?> attribute;
    private double value;
    private Boolean state;

    public HighHealthGearAttributeTalent(int unlockLevel, int learnPointCost, int regretPointCost, MobEffect effect, float healthThreshold, VaultGearAttribute<?> attribute, double value, Boolean state) {
        super(unlockLevel, learnPointCost, regretPointCost, effect, healthThreshold);
        this.attribute = attribute;
        this.value = value;
        this.state = state;
    }

    public HighHealthGearAttributeTalent() {
    }

    @Override
    public void onAdd(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::refreshSnapshot);
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::refreshSnapshot);
    }

    @Override
    public void onTick(SkillContext context) {
        super.onTick(context);
        ServerPlayer player = context.getSource().as(ServerPlayer.class).orElse(null);
        if (player == null) {
            return;
        }
        boolean newState = this.shouldGetBenefits((LivingEntity)player);
        if (this.isUnlocked() && newState) {
            this.onAddModifiers(context);
        } else {
            this.onRemoveModifiers(context);
        }
        if (!this.isUnlocked()) {
            this.state = null;
            return;
        }
        if (this.state == null || this.state != newState) {
            this.refreshSnapshot(player);
            this.state = newState;
        }
    }

    @Override
    public Stream<VaultGearAttributeInstance<?>> getGearAttributes(SkillContext context) {
        LivingEntity entity = context.getSource().as(LivingEntity.class).orElse(null);
        if (entity == null || this.shouldGetBenefits(entity)) {
            return Stream.of(VaultGearAttributeInstance.cast(this.attribute, this.value));
        }
        return Stream.empty();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.GEAR_ATTRIBUTE.writeBits(this.attribute, buffer);
        Adapters.DOUBLE.writeBits(this.value, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.attribute = Adapters.GEAR_ATTRIBUTE.readBits(buffer).orElseThrow();
        this.value = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.GEAR_ATTRIBUTE.writeNbt(this.attribute).ifPresent(tag -> nbt.m_128365_("attribute", tag));
            Adapters.DOUBLE.writeNbt(this.value).ifPresent(tag -> nbt.m_128365_("value", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.attribute = Adapters.GEAR_ATTRIBUTE.readNbt(nbt.m_128423_("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + nbt));
        this.value = (Double)Adapters.DOUBLE.readNbt(nbt.m_128423_("value")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.GEAR_ATTRIBUTE.writeJson(this.attribute).ifPresent(element -> json.add("attribute", element));
            Adapters.DOUBLE.writeJson(this.value).ifPresent(element -> json.add("value", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.attribute = Adapters.GEAR_ATTRIBUTE.readJson(json.get("attribute")).orElseThrow(() -> new IllegalStateException("Unknown attribute in " + json));
        this.value = (Double)Adapters.DOUBLE.readJson(json.get("value")).orElseThrow();
    }
}

