/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.luckyhit;

import iskallia.vault.event.ActiveFlagsCheck;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.BonkParticleMessage;
import iskallia.vault.network.message.LuckyHitParticleMessage;
import iskallia.vault.skill.ability.effect.BonkLuckyStrikeAbility;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.luckyhit.SweepingLuckyHitTalent;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.calc.LuckyHitHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import iskallia.vault.util.damage.CritHelper;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.List;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class LuckyHitTalent
extends LearnableSkill {
    public LuckyHitTalent(int unlockLevel, int learnPointCost, int regretPointCost) {
        super(unlockLevel, learnPointCost, regretPointCost);
    }

    protected LuckyHitTalent() {
    }

    public abstract void onLuckyHit(LivingHurtEvent var1);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void doLuckyHit(LivingHurtEvent event) {
        SweepingLuckyHitTalent cleave;
        if (ActiveFlagsCheck.isAnyFlagActiveLuckyHit()) {
            return;
        }
        if (event.getSource() instanceof ThornsReflectDamageSource) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)source;
        if (CritHelper.getCrit((Player)attacker)) {
            return;
        }
        if (AttackScaleHelper.getLastAttackScale((Player)attacker) < 1.0f) {
            return;
        }
        float probability = LuckyHitHelper.getLuckyHitChance((LivingEntity)attacker);
        MobEffectInstance battleCry = attacker.m_21124_(ModEffects.BATTLE_CRY_LUCKY_STRIKE);
        if (battleCry != null) {
            AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)attacker.f_19853_).getAbilities((Player)attacker);
            for (BonkLuckyStrikeAbility ability : abilities.getAll(BonkLuckyStrikeAbility.class, Skill::isUnlocked)) {
                int stacksUsed = ability.getMaxStacksUsedPerHit();
                MobEffectInstance newBattleCry = null;
                if (battleCry.m_19564_() - stacksUsed >= 0) {
                    newBattleCry = new MobEffectInstance(battleCry.m_19544_(), battleCry.m_19557_(), battleCry.m_19564_() - stacksUsed, false, false, true);
                } else {
                    stacksUsed = battleCry.m_19564_() + 1;
                }
                probability += ability.getLuckyHitChancePerStack() * (float)stacksUsed;
                attacker.f_19853_.m_6263_((Player)attacker, attacker.m_20182_().f_82479_, attacker.m_20182_().f_82480_, attacker.m_20182_().f_82481_, ModSounds.BONK, SoundSource.PLAYERS, 1.0f, 0.7f);
                attacker.m_6330_(ModSounds.BONK, SoundSource.PLAYERS, 1.0f, 0.7f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BonkParticleMessage(new Vec3(attacker.m_20185_(), attacker.m_20186_() + (double)(attacker.m_20206_() / 3.0f), attacker.m_20189_()), event.getEntity().m_142049_(), 7206307, 5 * stacksUsed, 5 + (int)(new Random().nextFloat() * 10.0f)));
                attacker.m_21195_(ModEffects.BATTLE_CRY_LUCKY_STRIKE);
                if (newBattleCry == null) continue;
                attacker.m_7292_(newBattleCry);
            }
        }
        if (attacker.m_183503_().m_5822_().nextFloat() >= probability) {
            return;
        }
        TalentTree tree = PlayerTalentsData.get((ServerLevel)attacker.f_19853_).getTalents((Player)attacker);
        boolean hasLuckyHit = false;
        List<LuckyHitTalent> luckyHitTalents = tree.getAll(LuckyHitTalent.class, Skill::isUnlocked);
        for (LuckyHitTalent talent : luckyHitTalents) {
            if (!(talent instanceof SweepingLuckyHitTalent)) continue;
            cleave = (SweepingLuckyHitTalent)talent;
            talent.onLuckyHit(event);
            hasLuckyHit = true;
        }
        for (LuckyHitTalent talent : luckyHitTalents) {
            if (talent instanceof SweepingLuckyHitTalent) {
                cleave = (SweepingLuckyHitTalent)talent;
                continue;
            }
            talent.onLuckyHit(event);
            hasLuckyHit = true;
        }
        if (!hasLuckyHit) {
            event.setAmount(event.getAmount() * 1.5f);
        }
        event.getEntity().m_183503_().m_6269_(null, event.getEntity(), SoundEvents.f_12313_, SoundSource.BLOCKS, 1.0f, 1.75f);
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new LuckyHitParticleMessage(new Vec3(event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_(), event.getEntity().m_20189_())));
    }
}

