/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.luckyhit;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.mana.ManaPlayer;
import iskallia.vault.network.message.LuckyHitManaParticleMessage;
import iskallia.vault.skill.talent.type.luckyhit.LuckyHitTalent;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class ManaLeechLuckyHitTalent
extends LuckyHitTalent {
    private float maxManaPercentage;

    public ManaLeechLuckyHitTalent(int unlockLevel, int learnPointCost, int regretPointCost, float maxManaPercentage) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.maxManaPercentage = maxManaPercentage;
    }

    public ManaLeechLuckyHitTalent() {
    }

    @Override
    public void onLuckyHit(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ManaPlayer) {
            ManaPlayer mana = (ManaPlayer)entity;
            mana.increaseMana(mana.getManaMax() * this.maxManaPercentage);
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new LuckyHitManaParticleMessage(new Vec3(event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)0.15f, event.getEntity().m_20189_()), event.getSource().m_7639_().m_142049_(), 65535, 20, event.getEntity().m_20206_()));
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.maxManaPercentage), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.maxManaPercentage = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.maxManaPercentage)).ifPresent(tag -> nbt.m_128365_("maxManaPercentage", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.maxManaPercentage = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("maxManaPercentage")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.maxManaPercentage)).ifPresent(element -> json.add("maxManaPercentage", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.maxManaPercentage = ((Float)Adapters.FLOAT.readJson(json.get("maxManaPercentage")).orElseThrow()).floatValue();
    }
}

