/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.mana;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.mana.ManaPlayer;
import iskallia.vault.skill.talent.type.health.ConditionalEntitySkill;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public abstract class HighManaTalent
extends ConditionalEntitySkill {
    private float manaThreshold;

    public HighManaTalent(int unlockLevel, int learnPointCost, int regretPointCost, MobEffect effect, float manaThreshold) {
        super(unlockLevel, learnPointCost, regretPointCost, effect);
        this.manaThreshold = manaThreshold;
    }

    protected HighManaTalent() {
    }

    @Override
    public boolean shouldGetBenefits(LivingEntity entity) {
        if (!(entity instanceof ManaPlayer)) {
            return false;
        }
        ManaPlayer owner = (ManaPlayer)entity;
        return owner.getMana() >= this.manaThreshold * owner.getManaMax();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.manaThreshold), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.manaThreshold = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.manaThreshold)).ifPresent(tag -> nbt.m_128365_("manaThreshold", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.manaThreshold = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("manaThreshold")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.manaThreshold)).ifPresent(element -> json.add("manaThreshold", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.manaThreshold = ((Float)Adapters.FLOAT.readJson(json.get("manaThreshold")).orElseThrow()).floatValue();
    }
}

