/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.onhit;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.ability.effect.JavelinPiercingAbility;
import iskallia.vault.skill.ability.effect.JavelinScatterAbility;
import iskallia.vault.skill.ability.effect.spi.AbstractJavelinAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.EntityFilterTalent;
import iskallia.vault.skill.talent.type.JavelinConductTalent;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import iskallia.vault.util.damage.CritHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EffectOnHitTalent
extends EntityFilterTalent {
    private MobEffect effect;
    private int amplifier;
    private int duration;
    private float probability;

    public EffectOnHitTalent(int unlockLevel, int learnPointCost, int regretPointCost, EntityPredicate[] filter, MobEffect effect, int amplifier, int duration, float probability) {
        super(unlockLevel, learnPointCost, regretPointCost, filter);
        this.effect = effect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.probability = probability;
    }

    public EffectOnHitTalent() {
    }

    public MobEffectInstance toEffect() {
        return new MobEffectInstance(this.effect, this.duration, this.amplifier, false, false, true);
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        Entity attacker;
        if (ActiveFlags.IS_AOE_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_TOTEM_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_CHARMED_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_DOT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_REFLECT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
            return;
        }
        boolean hasConduct = false;
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)entity;
                TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                    hasConduct = true;
                }
            }
            if (!hasConduct) {
                return;
            }
        }
        if (!((attacker = event.getSource().m_7639_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)attacker;
        if (!hasConduct && CritHelper.getCrit((Player)player)) {
            return;
        }
        TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        if (!hasConduct && AttackScaleHelper.getLastAttackScale((Player)player) < 1.0f) {
            return;
        }
        for (EffectOnHitTalent talent : talents.getAll(EffectOnHitTalent.class, Skill::isUnlocked)) {
            if (!talent.isValid(event.getEntity())) continue;
            int chances = 1;
            if (hasConduct && talent.toEffect().m_19544_() == ModEffects.GLACIAL_SHATTER) {
                for (AbstractJavelinAbility javelinAbility : abilities.getAll(AbstractJavelinAbility.class, Skill::isUnlocked)) {
                    if (javelinAbility instanceof JavelinScatterAbility) {
                        JavelinScatterAbility scatterAbility = (JavelinScatterAbility)javelinAbility;
                        chances = scatterAbility.getPiercing() * scatterAbility.getNumberOfJavelins();
                    }
                    if (!(javelinAbility instanceof JavelinPiercingAbility)) continue;
                    JavelinPiercingAbility piercingAbility = (JavelinPiercingAbility)javelinAbility;
                    chances = piercingAbility.getPiercing();
                }
            }
            if (ActiveFlags.IS_CHAINING_ATTACKING.isSet()) {
                AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
                chances = snapshot.getAttributeValue(ModGearAttributes.ON_HIT_CHAIN, VaultGearAttributeTypeMerger.intSum());
                if (player.m_183503_().m_5822_().nextFloat() >= talent.probability / Math.max(1.0f, (float)chances / 2.0f)) {
                    return;
                }
                event.getEntityLiving().m_7292_(talent.toEffect());
            }
            if (player.m_183503_().m_5822_().nextFloat() >= talent.probability / (float)Math.max(1, chances / 2)) {
                return;
            }
            event.getEntityLiving().m_7292_(talent.toEffect());
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.EFFECT.writeBits(this.effect, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.amplifier, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.duration, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.probability), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.effect = Adapters.EFFECT.readBits(buffer).orElseThrow();
        this.amplifier = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.duration = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.probability = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.EFFECT.writeNbt(this.effect).ifPresent(tag -> nbt.m_128365_("effect", tag));
            Adapters.INT.writeNbt(this.amplifier).ifPresent(tag -> nbt.m_128365_("amplifier", tag));
            Adapters.INT.writeNbt(this.duration).ifPresent(tag -> nbt.m_128365_("duration", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.probability)).ifPresent(tag -> nbt.m_128365_("probability", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.effect = Adapters.EFFECT.readNbt(nbt.m_128423_("effect")).orElseThrow(() -> new IllegalStateException("Unknown effect in " + nbt));
        this.amplifier = Adapters.INT.readNbt(nbt.m_128423_("amplifier")).orElse(0);
        this.duration = Adapters.INT.readNbt(nbt.m_128423_("duration")).orElse(0);
        this.probability = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("probability")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.EFFECT.writeJson(this.effect).ifPresent(element -> json.add("effect", element));
            Adapters.INT.writeJson(this.amplifier).ifPresent(element -> json.add("amplifier", element));
            Adapters.INT.writeJson(this.duration).ifPresent(element -> json.add("duration", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.probability)).ifPresent(element -> json.add("probability", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.effect = Adapters.EFFECT.readJson(json.get("effect")).orElseThrow(() -> new IllegalStateException("Unknown effect in " + json));
        this.amplifier = Adapters.INT.readJson(json.get("amplifier")).orElse(0);
        this.duration = Adapters.INT.readJson(json.get("duration")).orElse(0);
        this.probability = ((Float)Adapters.FLOAT.readJson(json.get("probability")).orElseThrow()).floatValue();
    }
}

