/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.onhit;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.PlayerActiveFlags;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.EntityFilterTalent;
import iskallia.vault.skill.talent.type.JavelinConductTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SweepingOnHitTalent
extends EntityFilterTalent {
    private float damagePercentage;
    private float damageRange;
    private float knockbackStrength;
    private float probability;

    public SweepingOnHitTalent(int unlockLevel, int learnPointCost, int regretPointCost, EntityPredicate[] filter, float damagePercentage, float damageRange, float knockbackStrength, float probability) {
        super(unlockLevel, learnPointCost, regretPointCost, filter);
        this.damagePercentage = damagePercentage;
        this.damageRange = damageRange;
        this.knockbackStrength = knockbackStrength;
        this.probability = probability;
    }

    public SweepingOnHitTalent() {
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        Entity source;
        if (ActiveFlags.IS_AOE_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_TOTEM_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_CHARMED_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_DOT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_REFLECT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
            return;
        }
        boolean hasConduct = false;
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)entity;
                TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                    hasConduct = true;
                }
            }
            if (!hasConduct) {
                return;
            }
        }
        if (!((source = event.getSource().m_7639_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)source;
        TalentTree talents = PlayerTalentsData.get(attacker.m_183503_()).getTalents((Player)attacker);
        Entity attacked = event.getEntity();
        ServerLevel world = attacker.m_183503_();
        for (SweepingOnHitTalent talent : talents.getAll(SweepingOnHitTalent.class, Skill::isUnlocked)) {
            if (world.m_5822_().nextFloat() >= talent.probability || !talent.isValid(event.getEntity())) continue;
            ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
                List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), talent.damageRange, Mob.class);
                nearby.remove(attacked);
                nearby.remove(attacker);
                nearby.removeIf(mob -> mob instanceof EternalEntity);
                nearby.forEach(mob -> {
                    Vec3 movement = mob.m_20184_();
                    mob.m_6469_(event.getSource(), event.getAmount() * talent.damagePercentage);
                    mob.m_20256_(movement);
                    mob.m_147240_((double)talent.knockbackStrength, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
                });
                PlayerActiveFlags.set((Player)attacker, PlayerActiveFlags.Flag.ATTACK_AOE, 2);
            });
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damagePercentage), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageRange), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.knockbackStrength), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.probability), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damagePercentage = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.damageRange = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.knockbackStrength = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.probability = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damagePercentage)).ifPresent(tag -> nbt.m_128365_("damagePercentage", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageRange)).ifPresent(tag -> nbt.m_128365_("damageRange", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.knockbackStrength)).ifPresent(tag -> nbt.m_128365_("knockbackStrength", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.probability)).ifPresent(tag -> nbt.m_128365_("probability", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damagePercentage = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("damagePercentage")).orElseThrow()).floatValue();
        this.damageRange = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("damageRange")).orElseThrow()).floatValue();
        this.knockbackStrength = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("knockbackStrength")).orElseThrow()).floatValue();
        this.probability = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("probability")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damagePercentage)).ifPresent(element -> json.add("damagePercentage", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageRange)).ifPresent(element -> json.add("damageRange", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.knockbackStrength)).ifPresent(element -> json.add("knockbackStrength", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.probability)).ifPresent(element -> json.add("probability", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damagePercentage = ((Float)Adapters.FLOAT.readJson(json.get("damagePercentage")).orElseThrow()).floatValue();
        this.damageRange = ((Float)Adapters.FLOAT.readJson(json.get("damageRange")).orElseThrow()).floatValue();
        this.knockbackStrength = ((Float)Adapters.FLOAT.readJson(json.get("knockbackStrength")).orElseThrow()).floatValue();
        this.probability = ((Float)Adapters.FLOAT.readJson(json.get("probability")).orElseThrow()).floatValue();
    }
}

