/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.onkill;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.event.PlayerActiveFlags;
import iskallia.vault.skill.talent.type.onkill.OnKillTalent;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SweepingOnKillTalent
extends OnKillTalent {
    private float damagePercentage;
    private float damageRange;
    private float knockbackStrength;
    private float probability;

    @Override
    public void onDeath(LivingDeathEvent event) {
        Entity source = event.getSource().m_7639_();
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)source;
        Entity attacked = event.getEntity();
        ServerLevel world = attacker.m_183503_();
        ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> {
            List<Mob> nearby = EntityHelper.getNearby((LevelAccessor)world, (Vec3i)attacked.m_142538_(), this.damageRange, Mob.class);
            nearby.remove(attacked);
            nearby.remove(attacker);
            nearby.removeIf(mob -> mob instanceof EternalEntity);
            double damage = (float)attacker.m_21133_(Attributes.f_22281_);
            float multiplier = AttackScaleHelper.getLastAttackScale((Player)attacker);
            damage *= (double)(0.2f + multiplier * multiplier * 0.8f);
            for (Mob mob2 : nearby) {
                Vec3 movement = mob2.m_20184_();
                mob2.m_6469_(event.getSource(), (float)(damage * (double)this.damagePercentage));
                mob2.m_20256_(movement);
                mob2.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            }
            PlayerActiveFlags.set((Player)attacker, PlayerActiveFlags.Flag.ATTACK_AOE, 2);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damagePercentage), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageRange), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.knockbackStrength), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.probability), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damagePercentage = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.damageRange = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.knockbackStrength = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.probability = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damagePercentage)).ifPresent(tag -> nbt.m_128365_("damagePercentage", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageRange)).ifPresent(tag -> nbt.m_128365_("damageRange", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.knockbackStrength)).ifPresent(tag -> nbt.m_128365_("knockbackStrength", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.probability)).ifPresent(tag -> nbt.m_128365_("probability", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damagePercentage = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("damagePercentage")).orElseThrow()).floatValue();
        this.damageRange = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("damageRange")).orElseThrow()).floatValue();
        this.knockbackStrength = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("knockbackStrength")).orElseThrow()).floatValue();
        this.probability = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("probability")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damagePercentage)).ifPresent(element -> json.add("damagePercentage", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageRange)).ifPresent(element -> json.add("damageRange", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.knockbackStrength)).ifPresent(element -> json.add("knockbackStrength", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.probability)).ifPresent(element -> json.add("probability", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damagePercentage = ((Float)Adapters.FLOAT.readJson(json.get("damagePercentage")).orElseThrow()).floatValue();
        this.damageRange = ((Float)Adapters.FLOAT.readJson(json.get("damageRange")).orElseThrow()).floatValue();
        this.knockbackStrength = ((Float)Adapters.FLOAT.readJson(json.get("knockbackStrength")).orElseThrow()).floatValue();
        this.probability = ((Float)Adapters.FLOAT.readJson(json.get("probability")).orElseThrow()).floatValue();
    }
}

