/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.tree;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.KnownTalentsMessage;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.SkillTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;

public class TalentTree
extends SkillTree {
    public void sync(SkillContext context) {
        this.syncTree(context);
    }

    public void syncTree(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> ModNetwork.CHANNEL.sendTo((Object)new KnownTalentsMessage(this), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }

    @Override
    public Skill mergeFrom(Skill other, SkillContext context) {
        if (!((other = super.mergeFrom(other, context)) instanceof SkillTree)) {
            return this;
        }
        SkillTree tree = (SkillTree)other;
        ArrayList<Skill> copy = new ArrayList<Skill>();
        HashSet<String> removed = new HashSet<String>(this.skills.stream().map(Skill::getId).filter(Objects::nonNull).toList());
        for (Skill skill2 : tree.skills) {
            removed.remove(skill2.getId());
            Skill merging = this.getForId(skill2.getId()).orElse(null);
            Skill merged = merging != null ? merging.mergeFrom(skill2, context) : skill2;
            if (merged == null) continue;
            merged.setParent(this);
            copy.add(merged);
        }
        this.skills = copy;
        for (String id : removed) {
            this.getForId(id).ifPresent(skill -> {
                if (skill instanceof LearnableSkill) {
                    LearnableSkill learnable = (LearnableSkill)skill;
                    context.setLearnPoints(context.getLearnPoints() + learnable.getLearnPointCost());
                }
            });
        }
        return this;
    }
}

