/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.snapshot;

import iskallia.vault.etching.EtchingSet;
import iskallia.vault.etching.set.EffectSet;
import iskallia.vault.etching.set.GearAttributeSet;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeRegistry;
import iskallia.vault.gear.attribute.custom.EffectGearAttribute;
import iskallia.vault.gear.attribute.type.EffectAvoidanceCombinedMerger;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.charm.CharmHelper;
import iskallia.vault.gear.charm.GearAttributeCharm;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.CuriosGearItem;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.gear.trinket.GearAttributeTrinket;
import iskallia.vault.gear.trinket.TrinketHelper;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.MagnetItem;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.talent.GearAttributeSkill;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.world.data.PlayerEtchingData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;

public class AttributeSnapshotCalculator {
    public static void computeSnapshot(ServerPlayer player, AttributeSnapshot snapshot) {
        AttributeSnapshotCalculator.addEtchingInformationToSnapshot(PlayerEtchingData.get(player.f_8924_).getEtchingSets((Player)player), snapshot);
        AttributeSnapshotCalculator.addTalentInformationToSnapshot(player, snapshot);
        AttributeSnapshotCalculator.addExpertiseInformationToSnapshot(player, snapshot);
        AttributeSnapshotCalculator.computeCuriosSnapshot(player, snapshot);
        int playerLevel = PlayerVaultStatsData.get(player.m_183503_()).getVaultStats((Player)player).getVaultLevel();
        AttributeSnapshotCalculator.computeGearSnapshot(arg_0 -> ((ServerPlayer)player).m_6844_(arg_0), arg_0 -> ((ItemCooldowns)player.m_36335_()).m_41519_(arg_0), playerLevel, snapshot);
    }

    private static void computeCuriosSnapshot(ServerPlayer player, AttributeSnapshot snapshot) {
        TrinketHelper.getTrinkets(IntegrationCurios.getCuriosItemStacks((LivingEntity)player), GearAttributeTrinket.class).forEach(gearTrinket -> {
            if (gearTrinket.isUsable((Player)player)) {
                ((GearAttributeTrinket)gearTrinket.trinket()).getAttributes().forEach(attributeInstance -> snapshot.gearAttributeValues.computeIfAbsent(attributeInstance.getAttribute(), v -> new AttributeSnapshot.AttributeValue()).addCachedValue(attributeInstance.getValue()));
            }
        });
        CharmHelper.getCharms(IntegrationCurios.getCuriosItemStacks((LivingEntity)player), GearAttributeCharm.class).forEach(gearCharm -> {
            if (gearCharm.isUsable((Player)player)) {
                if (CharmItem.hasValue(gearCharm.stack())) {
                    ((GearAttributeCharm)gearCharm.charm()).getAttributes(CharmItem.getValue(gearCharm.stack())).forEach(attributeInstance -> snapshot.gearAttributeValues.computeIfAbsent(attributeInstance.getAttribute(), v -> new AttributeSnapshot.AttributeValue()).addCachedValue(attributeInstance.getValue()));
                } else {
                    ((GearAttributeCharm)gearCharm.charm()).getAttributes().forEach(attributeInstance -> snapshot.gearAttributeValues.computeIfAbsent(attributeInstance.getAttribute(), v -> new AttributeSnapshot.AttributeValue()).addCachedValue(attributeInstance.getValue()));
                }
            }
        });
        IntegrationCurios.getCuriosItemStacks((LivingEntity)player).forEach((slot, stacks) -> stacks.forEach(stackTpl -> {
            CuriosGearItem curiosGearItem;
            ItemStack stack = (ItemStack)stackTpl.m_14418_();
            if (!AttributeGearData.hasData(stack)) {
                return;
            }
            Item patt4626$temp = stack.m_41720_();
            if (patt4626$temp instanceof CuriosGearItem && !(curiosGearItem = (CuriosGearItem)patt4626$temp).isIntendedSlot(stack, (String)slot)) {
                return;
            }
            if (stack.m_150930_((Item)ModItems.MAGNET) && MagnetItem.isLegacy(stack)) {
                return;
            }
            Object data = AttributeGearData.read(stack);
            for (VaultGearAttribute attribute : VaultGearAttributeRegistry.getRegistry()) {
                ((AttributeGearData)data).get(attribute, VaultGearAttributeTypeMerger.asList()).forEach(value -> snapshot.gearAttributeValues.computeIfAbsent(attribute, v -> new AttributeSnapshot.AttributeValue()).addCachedValue(value));
            }
        }));
    }

    public static void computeGearSnapshot(Function<EquipmentSlot, ItemStack> equipmentFn, Predicate<Item> isItemOnCooldown, int playerLevel, AttributeSnapshot snapshot) {
        ArrayList<ItemStack> gear = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Object gearItem;
            Item item;
            ItemStack stack2 = equipmentFn.apply(slot);
            if (stack2.m_41619_() || isItemOnCooldown.test(stack2.m_41720_()) || (item = stack2.m_41720_()) instanceof VaultGearItem && (!(gearItem = (VaultGearItem)item).isIntendedForSlot(stack2, slot) || gearItem.isBroken(stack2)) || (item = stack2.m_41720_()) instanceof CuriosGearItem && !(gearItem = (CuriosGearItem)item).isIntendedSlot(stack2, slot)) continue;
            gear.add(stack2);
        }
        gear.forEach(stack -> {
            VaultGearData vData;
            Object data = AttributeGearData.read(stack);
            if (data instanceof VaultGearData && (vData = (VaultGearData)data).getItemLevel() > playerLevel) {
                return;
            }
            for (VaultGearAttribute attribute : VaultGearAttributeRegistry.getRegistry()) {
                ((AttributeGearData)data).get(attribute, VaultGearAttributeTypeMerger.asList()).forEach(value -> snapshot.gearAttributeValues.computeIfAbsent(attribute, v -> new AttributeSnapshot.AttributeValue()).addCachedValue(value));
            }
        });
        AttributeSnapshotCalculator.computeAvoidances(snapshot);
    }

    private static void computeAvoidances(AttributeSnapshot snapshot) {
        snapshot.getAttributeValue(ModGearAttributes.EFFECT_AVOIDANCE, EffectAvoidanceCombinedMerger.getInstance()).getAvoidanceChances().entrySet().stream().filter(entry -> ((Float)entry.getValue()).floatValue() >= 1.0f).forEach(entry -> snapshot.gearAttributeValues.computeIfAbsent(ModGearAttributes.EFFECT_IMMUNITY, v -> new AttributeSnapshot.AttributeValue()).addCachedValue(entry.getKey()));
    }

    private static void addEtchingInformationToSnapshot(Collection<EtchingSet<?>> etchingSets, AttributeSnapshot snapshot) {
        snapshot.etchings = new ArrayList(etchingSets);
        etchingSets.forEach(etchingSet -> {
            if (etchingSet instanceof GearAttributeSet) {
                GearAttributeSet attributeSet = (GearAttributeSet)((Object)etchingSet);
                attributeSet.getAttributes().forEach(value -> snapshot.gearAttributeValues.computeIfAbsent(value.getAttribute(), v -> new AttributeSnapshot.AttributeValue()).addCachedValue(value.getValue()));
            }
            if (etchingSet instanceof EffectSet) {
                EffectSet effectSet = (EffectSet)((Object)etchingSet);
                List<EffectGearAttribute> effectAttributes = effectSet.getGrantedEffects().stream().map(EffectSet.GrantedEffect::asGearAttribute).toList();
                snapshot.gearAttributeValues.computeIfAbsent(ModGearAttributes.EFFECT, v -> new AttributeSnapshot.AttributeValue()).addCachedValues(effectAttributes);
            }
        });
    }

    private static void addTalentInformationToSnapshot(ServerPlayer player, AttributeSnapshot snapshot) {
        TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        talents.iterate(GearAttributeSkill.class, attributeSkill -> {
            Skill skill;
            if (attributeSkill instanceof Skill && (skill = (Skill)((Object)attributeSkill)).isUnlocked()) {
                attributeSkill.getGearAttributes(SkillContext.of(player)).forEach(attributeValue -> snapshot.gearAttributeValues.computeIfAbsent(attributeValue.getAttribute(), v -> new AttributeSnapshot.AttributeValue()).addCachedValue(attributeValue.getValue()));
            }
        });
    }

    private static void addExpertiseInformationToSnapshot(ServerPlayer player, AttributeSnapshot snapshot) {
        ExpertiseTree expertise = PlayerExpertisesData.get(player.m_183503_()).getExpertises((Player)player);
        expertise.iterate(GearAttributeSkill.class, attributeSkill -> {
            Skill skill;
            if (attributeSkill instanceof Skill && (skill = (Skill)((Object)attributeSkill)).isUnlocked()) {
                attributeSkill.getGearAttributes(SkillContext.ofExpertise(player)).forEach(attributeValue -> snapshot.gearAttributeValues.computeIfAbsent(attributeValue.getAttribute(), v -> new AttributeSnapshot.AttributeValue()).addCachedValue(attributeValue.getValue()));
            }
        });
    }
}

