/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.OperableTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.source.TaskSource;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class BountyTask
extends OperableTask {
    private State state;
    private long timeout;

    public BountyTask() {
    }

    public BountyTask(Task delegate, State state) {
        super(delegate);
        this.state = state;
        this.timeout = 0L;
    }

    public BountyTask setState(State state, long timeout) {
        this.state = state;
        this.timeout = timeout;
        return this;
    }

    @Override
    public boolean shouldBeOperating(TaskSource source) {
        return super.shouldBeOperating(source) && this.state == State.ACTIVE && this.timeout > 0L;
    }

    @Override
    public void onTick(TaskSource source) {
        super.onTick(source);
        if (this.state == State.COMPLETE || this.state == State.ABANDONED) {
            --this.timeout;
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT.writeBits(this.state.ordinal(), buffer);
        Adapters.LONG.writeBits(this.timeout, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.state = State.values()[Adapters.INT.readBits(buffer).orElse(0)];
        this.timeout = Adapters.LONG.readBits(buffer).orElse(0L);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.state.ordinal()).ifPresent(value -> nbt.m_128365_("state", value));
            Adapters.LONG.writeNbt(this.timeout).ifPresent(value -> nbt.m_128365_("timeout", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.state = State.values()[Adapters.INT.readNbt((Tag)nbt).orElse(0)];
        this.timeout = Adapters.LONG.readNbt((Tag)nbt).orElse(0L);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.state.ordinal()).ifPresent(value -> json.add("state", value));
            Adapters.LONG.writeJson(this.timeout).ifPresent(value -> json.add("timeout", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.state = State.values()[Adapters.INT.readJson(json.get("state")).orElse(0)];
        this.timeout = Adapters.LONG.readJson(json.get("timeout")).orElse(0L);
    }

    public static enum State {
        ACTIVE,
        AVAILABLE,
        COMPLETE,
        ABANDONED;

    }
}

