/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.block.base.GodAltarTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.gear.charm.CharmHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.task.Task;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.world.data.GodAltarData;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.ServerVaults;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CompleteGodAltarTask
extends Task {
    public static final Map<VaultGod, List<String>> MESSAGES = new HashMap<VaultGod, List<String>>();
    private static final ResourceLocation GROUP = VaultMod.id("god_altar");
    private UUID uuid;
    private ResourceLocation modifierPool;
    private boolean requiresDraining;
    private boolean completed;

    public CompleteGodAltarTask() {
    }

    public CompleteGodAltarTask(UUID uuid, ResourceLocation modifierPool, boolean requiresDraining) {
        this.uuid = uuid;
        this.modifierPool = modifierPool;
        this.requiresDraining = requiresDraining;
        this.completed = false;
    }

    @Override
    public boolean isCompleted(TaskSource source) {
        return this.completed;
    }

    @Override
    public void onAttach(TaskSource source) {
        CommonEvents.PLAYER_INTERACT.register(this, event -> {
            GodAltarTileEntity altar;
            EntityTaskSource entitySource;
            if (event.getWorld().m_5776_() || !this.requiresDraining || this.completed) {
                return;
            }
            if (!(source instanceof EntityTaskSource) || !(entitySource = (EntityTaskSource)source).matches((Entity)event.getPlayer())) {
                return;
            }
            BlockEntity patt2987$temp = event.getWorld().m_7702_(event.getPos());
            if (!(patt2987$temp instanceof GodAltarTileEntity) || !this.uuid.equals((altar = (GodAltarTileEntity)patt2987$temp).getUuid())) {
                return;
            }
            this.onComplete(event.getWorld(), event.getPlayer(), source);
        });
        super.onAttach(source);
    }

    @Override
    public void onStart(TaskSource source) {
        super.onStart(source);
        if (!this.completed && !this.requiresDraining && source instanceof EntityTaskSource) {
            EntityTaskSource entitySource = (EntityTaskSource)source;
            for (Player player : entitySource.getEntities(Player.class)) {
                this.onComplete(player.f_19853_, player, source);
            }
        }
    }

    private void onComplete(Level world, Player player, TaskSource source) {
        VaultGod god = GodAltarData.get(this.uuid).map(GodAltarData.Entry::getGod).orElse(null);
        if (god == null) {
            return;
        }
        PlayerReputationData.attemptFavour(player, god, source.getRandom());
        this.completed = true;
        GodAltarData.remove(this.uuid);
        Vault vault = ServerVaults.get(world).orElse(null);
        int level = vault == null ? 0 : vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        CharmHelper.getCharms((LivingEntity)player).forEach(charm -> {
            if (vault == null || !charm.isUsable(player)) {
                return;
            }
            CharmItem.addUsedVault(charm.stack(), vault.get(Vault.ID));
        });
        List<VaultModifier<?>> modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(this.modifierPool, level, source.getRandom());
        Object2IntOpenHashMap groups = new Object2IntOpenHashMap();
        modifiers.forEach(arg_0 -> CompleteGodAltarTask.lambda$onComplete$2((Object2IntMap)groups, arg_0));
        ObjectIterator it = groups.object2IntEntrySet().iterator();
        TextComponent suffix = new TextComponent("");
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            suffix.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (!it.hasNext()) continue;
            suffix.m_7220_((Component)new TextComponent(", "));
        }
        TextComponent text = new TextComponent("");
        if (!modifiers.isEmpty()) {
            text.m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        }
        HashSet<Player> notified = new HashSet<Player>();
        notified.add(player);
        if (vault != null) {
            groups.forEach((modifier, count) -> vault.ifPresent(Vault.MODIFIERS, value -> {
                for (Modifiers.Entry entry : value.getEntries()) {
                    if (!GROUP.equals((Object)entry.get(Modifiers.Entry.CONTEXT).get(ModifierContext.GROUP))) continue;
                    entry.get(Modifiers.Entry.CONTEXT).setExpired();
                }
                value.addModifier((VaultModifier<?>)modifier, (int)count, true, source.getRandom(), context -> context.set(ModifierContext.GROUP, VaultMod.id("god_altar")));
            }));
            for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                listener.getPlayer().ifPresent(notified::add);
            }
        }
        String message = MESSAGES.get((Object)god).get(source.getRandom().nextInt(MESSAGES.get((Object)god).size()));
        MutableComponent vgName = new TextComponent(god.getName()).m_130940_(god.getChatColor());
        vgName.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)god.getHoverChatComponent())));
        TextComponent txt = new TextComponent("");
        txt.m_7220_((Component)vgName).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(message));
        for (Player other : notified) {
            world.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
            other.m_5661_((Component)txt, false);
            if (modifiers.isEmpty()) continue;
            other.m_5661_((Component)text, false);
        }
    }

    @Override
    public void onDetach() {
        CommonEvents.PLAYER_INTERACT.release(this);
        super.onDetach();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.UUID.writeBits(this.uuid, buffer);
        Adapters.IDENTIFIER.asNullable().writeBits(this.modifierPool, buffer);
        Adapters.BOOLEAN.writeBits(this.requiresDraining, buffer);
        Adapters.BOOLEAN.writeBits(this.completed, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.uuid = Adapters.UUID.readBits(buffer).orElseThrow();
        this.modifierPool = Adapters.IDENTIFIER.asNullable().readBits(buffer).orElse(null);
        this.requiresDraining = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        this.completed = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.UUID.writeNbt(this.uuid).ifPresent(value -> nbt.m_128365_("uuid", value));
            Adapters.IDENTIFIER.writeNbt(this.modifierPool).ifPresent(value -> nbt.m_128365_("modifierPool", value));
            Adapters.BOOLEAN.writeNbt(this.requiresDraining).ifPresent(value -> nbt.m_128365_("requiresDraining", value));
            Adapters.BOOLEAN.writeNbt(this.completed).ifPresent(value -> nbt.m_128365_("completed", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElse(null);
        this.modifierPool = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("modifierPool")).orElse(null);
        this.requiresDraining = Adapters.BOOLEAN.readNbt(nbt.m_128423_("requiresDraining")).orElse(false);
        this.completed = Adapters.BOOLEAN.readNbt(nbt.m_128423_("completed")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.UUID.writeJson(this.uuid).ifPresent(value -> json.add("uuid", value));
            Adapters.IDENTIFIER.writeJson(this.modifierPool).ifPresent(value -> json.add("modifierPool", value));
            Adapters.BOOLEAN.writeJson(this.requiresDraining).ifPresent(value -> json.add("requiresDraining", value));
            Adapters.BOOLEAN.writeJson(this.completed).ifPresent(value -> json.add("completed", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.uuid = Adapters.UUID.readJson(json.get("uuid")).orElse(null);
        this.modifierPool = Adapters.IDENTIFIER.readJson(json.get("modifierPool")).orElse(null);
        this.requiresDraining = Adapters.BOOLEAN.readJson(json.get("requiresDraining")).orElse(false);
        this.completed = Adapters.BOOLEAN.readJson(json.get("completed")).orElse(false);
    }

    private static /* synthetic */ void lambda$onComplete$2(Object2IntMap groups, VaultModifier modifier) {
        groups.put((Object)modifier, groups.getOrDefault((Object)modifier, 0) + 1);
    }

    static {
        MESSAGES.put(VaultGod.VELARA, Arrays.asList("Our domain's ground will carve a path.", "Tread upon our domain with care and it will respond in kind.", "May your desire blossom into a wildfire.", "Creation bends to our will.", "The soil whispers secrets of those who've walked before.", "Beneath the surface, our whispers guide fate.", "Our heartbeats sync with the world's tremors.", "Our reach extends beyond the visible horizon."));
        MESSAGES.put(VaultGod.TENOS, Arrays.asList("May foresight guide your step.", "Careful planning and strategy may lead you.", "A set choice; followed through and flawlessly executed.", "Chance's hand may favour your goals.", "In the dance of fate and strategy, precision reigns.", "To foresee is to command the threads of destiny.", "Tread lightly on the line between choice and predestination.", "To conquer fate, first understand its riddles."));
        MESSAGES.put(VaultGod.WENDARR, Arrays.asList("Seize the opportunity.", "A single instant, stretched to infinity.", "Your future glows golden with possibility.", "Hasten and value every passing moment.", "With every heartbeat, an epoch is born.", "The sands of time are fleeting; grasp them.", "The dance of time is swift; miss not its rhythm.", "The pendulum of time swings but once for each moment."));
        MESSAGES.put(VaultGod.IDONA, Arrays.asList("Enforce your path through obstacles.", "Our vigor may aid your conquest.", "Cherish this mote of my might.", "A tempest incarnate.", "Rise, like the waves, unyielding and fierce.", "Forge ahead with the fury of storms.", "With relentless force, mold your path.", "Harness my wrath to awaken the dormant."));
    }
}

