/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.task.Task;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.world.data.GodAltarData;
import iskallia.vault.world.data.ServerVaults;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class FailGodAltarTask
extends Task {
    public static final Map<VaultGod, List<String>> MESSAGES = new HashMap<VaultGod, List<String>>();
    private UUID vaultUuid;
    private UUID playerUuid;
    private UUID altarUuid;
    private ResourceLocation modifierPool;

    public FailGodAltarTask() {
    }

    public FailGodAltarTask(UUID vaultUuid, UUID playerUuid, UUID altarUuid, ResourceLocation modifierPool) {
        this.vaultUuid = vaultUuid;
        this.playerUuid = playerUuid;
        this.altarUuid = altarUuid;
        this.modifierPool = modifierPool;
    }

    @Override
    public boolean isCompleted(TaskSource source) {
        return false;
    }

    @Override
    public void onTick(TaskSource source) {
        Vault vault;
        super.onTick(source);
        if (!(this.vaultUuid == null || (vault = (Vault)ServerVaults.get(this.vaultUuid).orElse(null)) != null && vault.get(Vault.LISTENERS).contains(this.playerUuid))) {
            this.onStop(source);
        }
    }

    @Override
    public void onStop(TaskSource source) {
        EntityTaskSource entitySource;
        Set<ServerPlayer> entities;
        VaultGod god = GodAltarData.get(this.altarUuid).map(GodAltarData.Entry::getGod).orElse(null);
        if (god == null) {
            return;
        }
        GodAltarData.remove(this.altarUuid);
        ServerPlayer player = null;
        if (source instanceof EntityTaskSource && !(entities = (entitySource = (EntityTaskSource)source).getEntities(ServerPlayer.class)).isEmpty()) {
            player = entities.iterator().next();
        }
        if (player == null) {
            return;
        }
        Vault vault = ServerVaults.get(this.vaultUuid).orElse(null);
        int level = vault == null ? 0 : vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        List<VaultModifier<?>> modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(this.modifierPool, level, source.getRandom());
        Object2IntOpenHashMap groups = new Object2IntOpenHashMap();
        modifiers.forEach(arg_0 -> FailGodAltarTask.lambda$onStop$0((Object2IntMap)groups, arg_0));
        ObjectIterator it = groups.object2IntEntrySet().iterator();
        TextComponent suffix = new TextComponent("");
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            suffix.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (!it.hasNext()) continue;
            suffix.m_7220_((Component)new TextComponent(", "));
        }
        TextComponent text = new TextComponent("");
        if (!modifiers.isEmpty()) {
            text.m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        }
        HashSet<ServerPlayer> notified = new HashSet<ServerPlayer>();
        notified.add(player);
        if (vault != null) {
            groups.forEach((modifier, count) -> vault.ifPresent(Vault.MODIFIERS, value -> value.addModifier((VaultModifier<?>)modifier, (int)count, true, source.getRandom())));
            for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                listener.getPlayer().ifPresent(notified::add);
            }
        }
        String message = MESSAGES.get((Object)god).get(source.getRandom().nextInt(MESSAGES.get((Object)god).size()));
        MutableComponent vgName = new TextComponent(god.getName()).m_130940_(god.getChatColor());
        vgName.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)god.getHoverChatComponent())));
        MutableComponent txt = new TextComponent("").m_7220_((Component)vgName).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(message));
        for (Player player2 : notified) {
            player2.f_19853_.m_6263_(null, player2.m_20185_(), player2.m_20186_(), player2.m_20189_(), SoundEvents.f_11703_, SoundSource.PLAYERS, 0.9f, 0.5f);
            player2.m_5661_((Component)txt, false);
            if (modifiers.isEmpty()) continue;
            player2.m_5661_((Component)text, false);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.UUID.writeBits(this.vaultUuid, buffer);
        Adapters.UUID.writeBits(this.playerUuid, buffer);
        Adapters.UUID.writeBits(this.altarUuid, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.vaultUuid = Adapters.UUID.readBits(buffer).orElse(null);
        this.playerUuid = Adapters.UUID.readBits(buffer).orElse(null);
        this.altarUuid = Adapters.UUID.readBits(buffer).orElse(null);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.UUID.writeNbt(this.vaultUuid).ifPresent(value -> nbt.m_128365_("vaultUuid", value));
            Adapters.UUID.writeNbt(this.playerUuid).ifPresent(value -> nbt.m_128365_("playerUuid", value));
            Adapters.UUID.writeNbt(this.altarUuid).ifPresent(value -> nbt.m_128365_("altarUuid", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.vaultUuid = Adapters.UUID.readNbt(nbt.m_128423_("vaultUuid")).orElse(null);
        this.playerUuid = Adapters.UUID.readNbt(nbt.m_128423_("playerUuid")).orElse(null);
        this.altarUuid = Adapters.UUID.readNbt(nbt.m_128423_("altarUuid")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.UUID.writeJson(this.vaultUuid).ifPresent(value -> json.add("vaultUuid", value));
            Adapters.UUID.writeJson(this.playerUuid).ifPresent(value -> json.add("playerUuid", value));
            Adapters.UUID.writeJson(this.altarUuid).ifPresent(value -> json.add("altarUuid", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.vaultUuid = Adapters.UUID.readJson(json.get("vaultUuid")).orElse(null);
        this.playerUuid = Adapters.UUID.readJson(json.get("playerUuid")).orElse(null);
        this.altarUuid = Adapters.UUID.readJson(json.get("altarUuid")).orElse(null);
    }

    private static /* synthetic */ void lambda$onStop$0(Object2IntMap groups, VaultModifier modifier) {
        groups.put((Object)modifier, groups.getOrDefault((Object)modifier, 0) + 1);
    }

    static {
        MESSAGES.put(VaultGod.VELARA, Arrays.asList("The harmony of the natural world eludes you.", "The beauty of nature thrives on resilience, but your actions have brought only discord.", "Your failures wither the very essence of life.", "The song of nature laments your inadequacy.", "You tarnish the purity of nature with your missteps."));
        MESSAGES.put(VaultGod.TENOS, Arrays.asList("Even the wisest can stumble on their path to enlightenment.", "Seek knowledge, learn from your failures, and you shall find your way.", "Failure is but a stepping stone on the road to enlightenment.", "Even the most brilliant minds face setbacks.", "In the pursuit of wisdom, missteps are bound to occur."));
        MESSAGES.put(VaultGod.WENDARR, Arrays.asList("A moment lost is a chance wasted.", "The sands of time never cease their relentless march.", "In the grand tapestry of existence, your actions are but threads.", "Time's embrace can be both cruel and kind.", "As the clock ticks, so do your choices shape your destiny."));
        MESSAGES.put(VaultGod.IDONA, Arrays.asList("Perhaps you should consider a different path.", "Weakness is a burden that few can afford.", "Your feeble attempt have left much to be desired.", "A hunter must be swift to adapt, or they are doomed to fail.", "No smiles will be cast upon those who crumble in the face of adversity."));
    }
}

