/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.Task;
import iskallia.vault.task.source.TaskSource;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class OperableTask
extends Task {
    protected Task delegate;
    protected boolean operating;

    public OperableTask() {
    }

    public OperableTask(Task delegate) {
        this.delegate = delegate;
        this.operating = false;
    }

    public Task getDelegate() {
        return this.delegate;
    }

    public boolean isOperating() {
        return this.operating;
    }

    public boolean shouldBeOperating(TaskSource source) {
        return !this.delegate.isCompleted(source);
    }

    @Override
    public boolean isCompleted(TaskSource source) {
        return this.delegate.isCompleted(source);
    }

    @Override
    public void onAttach(TaskSource source) {
        if (this.isOperating()) {
            this.delegate.onAttach(source);
        }
    }

    @Override
    public void onStart(TaskSource source) {
        this.delegate.onStart(source);
    }

    @Override
    public void onTick(TaskSource source) {
        this.delegate.onTick(source);
        boolean newOperating = this.shouldBeOperating(source);
        if (newOperating && !this.operating) {
            this.onStart(source);
        } else if (!newOperating && this.operating) {
            this.onStop(source);
        }
        this.operating = newOperating;
    }

    @Override
    public void onStop(TaskSource source) {
        this.delegate.onStop(source);
    }

    @Override
    public void onDetach() {
        if (this.isOperating()) {
            this.delegate.onDetach();
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.TASK.writeBits(this.delegate, buffer);
        buffer.writeBoolean(this.operating);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.delegate = (Task)Adapters.TASK.readBits(buffer).orElseThrow();
        this.operating = buffer.readBoolean();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.TASK.writeNbt(this.delegate).ifPresent(value -> nbt.m_128365_("delegate", value));
            Adapters.BOOLEAN.writeNbt(this.operating).ifPresent(value -> nbt.m_128365_("operating", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.delegate = (Task)Adapters.TASK.readNbt((Tag)nbt.m_128469_("delegate")).orElseThrow();
        this.operating = Adapters.BOOLEAN.readNbt(nbt.m_128423_("operating")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.TASK.writeJson(this.delegate).ifPresent(value -> json.add("delegate", value));
            Adapters.BOOLEAN.writeJson(this.operating).ifPresent(value -> json.add("operating", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.delegate = (Task)Adapters.TASK.readJson((JsonElement)json.getAsJsonObject("delegate")).orElseThrow();
        this.operating = Adapters.BOOLEAN.readJson(json.get("operating")).orElse(false);
    }
}

