/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.task.util.IProgressTask;
import iskallia.vault.task.util.TaskProgress;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class ProgressConfiguredTask<N extends Number, C extends ConfiguredTask.Config>
extends ConfiguredTask<C>
implements IProgressTask {
    protected N currentCount;
    protected N targetCount;
    private N zero;
    private ISimpleAdapter<N, ? super Tag, ? super JsonElement> adapter;
    private Comparator<N> comparator;

    public ProgressConfiguredTask(N zero, ISimpleAdapter<N, ? super Tag, ? super JsonElement> adapter, Comparator<N> comparator) {
        this.zero = zero;
        this.adapter = adapter;
        this.comparator = comparator;
    }

    public ProgressConfiguredTask(C config, N zero, ISimpleAdapter<N, ? super Tag, ? super JsonElement> adapter, Comparator<N> comparator) {
        super(config);
        this.zero = zero;
        this.adapter = adapter;
        this.comparator = comparator;
        this.currentCount = this.zero;
        this.targetCount = this.zero;
    }

    @Override
    public boolean isCompleted(TaskSource source) {
        return super.isCompleted(source) && this.comparator.compare(this.currentCount, this.targetCount) >= 0;
    }

    @Override
    public TaskProgress getProgress() {
        return new TaskProgress((Number)this.currentCount, (Number)this.targetCount);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.adapter.writeBits(this.currentCount, buffer);
        this.adapter.writeBits(this.targetCount, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.currentCount = (Number)this.adapter.readBits(buffer).orElse(this.zero);
        this.targetCount = (Number)this.adapter.readBits(buffer).orElse(this.zero);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            this.adapter.writeNbt(this.currentCount).ifPresent(value -> nbt.m_128365_("currentCount", value));
            this.adapter.writeNbt(this.targetCount).ifPresent(value -> nbt.m_128365_("targetCount", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!this.isPopulated()) {
            return;
        }
        this.currentCount = (Number)this.adapter.readNbt((Tag)nbt.m_128423_("currentCount")).orElse(this.zero);
        this.targetCount = (Number)this.adapter.readNbt((Tag)nbt.m_128423_("targetCount")).orElse(this.zero);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            this.adapter.writeJson(this.currentCount).ifPresent(value -> json.add("currentCount", value));
            this.adapter.writeJson(this.targetCount).ifPresent(value -> json.add("targetCount", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!this.isPopulated()) {
            return;
        }
        this.currentCount = (Number)this.adapter.readJson((JsonElement)json.get("currentCount")).orElse(this.zero);
        this.targetCount = (Number)this.adapter.readJson((JsonElement)json.get("targetCount")).orElse(this.zero);
    }
}

