/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.serializable.ISerializable;
import iskallia.vault.task.AchievementTask;
import iskallia.vault.task.BountyTask;
import iskallia.vault.task.CompleteGodAltarTask;
import iskallia.vault.task.CraftingTask;
import iskallia.vault.task.FailGodAltarTask;
import iskallia.vault.task.InteractBlockTask;
import iskallia.vault.task.ItemStatTask;
import iskallia.vault.task.KillEntityTask;
import iskallia.vault.task.LootChestItemTask;
import iskallia.vault.task.LootChestTask;
import iskallia.vault.task.MineBlockTask;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.TimedTask;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.renderer.context.RendererContext;
import iskallia.vault.task.source.TaskSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class Task
implements ISerializable<CompoundTag, JsonObject> {
    protected List<TaskRenderer<?, ?>> renderer = new ArrayList();

    public abstract boolean isCompleted(TaskSource var1);

    public void onAttach(TaskSource source) {
    }

    public void onStart(TaskSource source) {
        this.onAttach(source);
    }

    public void onTick(TaskSource source) {
    }

    public void onStop(TaskSource source) {
        this.onDetach();
    }

    public void onDetach() {
    }

    public <T extends Task> T add(TaskRenderer<?, ?> renderer) {
        this.renderer.add(renderer);
        return (T)this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <C extends RendererContext> void render(C context) {
        for (TaskRenderer<?, ?> instance : this.renderer) {
            instance.render(this, context);
        }
    }

    public <T extends Task> T copy() {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        Adapters.TASK.writeBits(this, (BitBuffer)buffer);
        buffer.setPosition(0);
        return (T)((Task)Adapters.TASK.readBits(buffer).orElseThrow());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_3.writeBits(this.renderer.size(), buffer);
        for (TaskRenderer<?, ?> instance : this.renderer) {
            Adapters.TASK_RENDERER.get(this).writeBits(instance, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            this.renderer.add(Adapters.TASK_RENDERER.get(this).readBits(buffer).orElse(null));
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.renderer.size() == 1) {
            Adapters.TASK_RENDERER.get(this).writeNbt(this.renderer.get(0)).ifPresent(value -> nbt.m_128365_("renderer", value));
        } else if (this.renderer.size() > 1) {
            ListTag list = new ListTag();
            for (TaskRenderer<?, ?> instance : this.renderer) {
                Adapters.TASK_RENDERER.get(this).writeNbt(instance).ifPresent(arg_0 -> list.add(arg_0));
            }
            nbt.m_128365_("renderer", (Tag)list);
        }
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.renderer = new ArrayList();
        Tag tag = nbt.m_128423_("renderer");
        if (tag instanceof CompoundTag) {
            CompoundTag tag2 = (CompoundTag)tag;
            this.renderer.add(Adapters.TASK_RENDERER.get(this).readNbt((Tag)tag2).orElse(null));
        } else {
            ListTag tag3;
            tag = nbt.m_128423_("renderer");
            if (tag instanceof ListTag && (tag3 = (ListTag)tag).m_7264_() == 10) {
                for (int i = 0; i < tag3.size(); ++i) {
                    this.renderer.add(Adapters.TASK_RENDERER.get(this).readNbt((Tag)tag3.m_128728_(i)).orElse(null));
                }
            }
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        if (this.renderer.size() == 1) {
            Adapters.TASK_RENDERER.get(this).writeJson(this.renderer.get(0)).ifPresent(value -> json.add("renderer", value));
        } else if (this.renderer.size() > 1) {
            JsonArray list = new JsonArray();
            for (TaskRenderer<?, ?> instance : this.renderer) {
                Adapters.TASK_RENDERER.get(this).writeJson(instance).ifPresent(arg_0 -> ((JsonArray)list).add(arg_0));
            }
            json.add("renderer", (JsonElement)list);
        }
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.renderer.clear();
        JsonElement jsonElement = json.get("renderer");
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            this.renderer.add(Adapters.TASK_RENDERER.get(this).readJson((JsonElement)object).orElse(null));
        } else {
            jsonElement = json.get("renderer");
            if (jsonElement instanceof JsonArray) {
                JsonArray array = (JsonArray)jsonElement;
                for (int i = 0; i < array.size(); ++i) {
                    this.renderer.add(Adapters.TASK_RENDERER.get(this).readJson(array.get(i)).orElse(null));
                }
            }
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<Task> {
        public Adapter() {
            super("type", false);
            this.register("node", NodeTask.class, NodeTask::new);
            this.register("timed", TimedTask.class, TimedTask::new);
            this.register("bounty", BountyTask.class, BountyTask::new);
            this.register("achievement", AchievementTask.class, AchievementTask::new);
            this.register("kill_entity", KillEntityTask.class, KillEntityTask::new);
            this.register("loot_chest", LootChestTask.class, LootChestTask::new);
            this.register("loot_chest_item", LootChestItemTask.class, LootChestItemTask::new);
            this.register("mine_block", MineBlockTask.class, MineBlockTask::new);
            this.register("interact_block", InteractBlockTask.class, InteractBlockTask::new);
            this.register("crafting", CraftingTask.class, CraftingTask::new);
            this.register("item_stat", ItemStatTask.class, ItemStatTask::new);
            this.register("complete_god_altar", CompleteGodAltarTask.class, CompleteGodAltarTask::new);
            this.register("fail_god_altar", FailGodAltarTask.class, FailGodAltarTask::new);
        }

        @Override
        @Nullable
        protected Task readSuppliedJson(JsonElement json) {
            Task task = (Task)super.readSuppliedJson(json);
            if (json instanceof JsonObject) {
                JsonObject object = (JsonObject)json;
                if (!(task instanceof NodeTask) && object.has("children")) {
                    NodeTask node = new NodeTask(task, new NodeTask[0]);
                    node.readJson(object);
                    return node;
                }
            }
            return task;
        }
    }
}

