/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer.context;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec3;

public class RendererContext {
    private PoseStack matrices;
    private float tickDelta;
    private MultiBufferSource.BufferSource bufferSource;
    private Font font;

    public RendererContext(PoseStack matrices, float tickDelta, MultiBufferSource.BufferSource bufferSource, Font font) {
        this.matrices = matrices;
        this.tickDelta = tickDelta;
        this.bufferSource = bufferSource;
        this.font = font;
    }

    public PoseStack getMatrices() {
        return this.matrices;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public void push() {
        this.matrices.m_85836_();
    }

    public void pop() {
        this.matrices.m_85849_();
    }

    public void translate(double x, double y, double z) {
        this.matrices.m_85837_(x, y, z);
    }

    public void translate(Vec3 vector) {
        this.translate(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public void translate(Vector3d vector) {
        this.translate(vector.f_86214_, vector.f_86215_, vector.f_86216_);
    }

    public void scale(double x, double y, double z) {
        this.matrices.m_85841_((float)x, (float)y, (float)z);
    }

    public void scale(Vec3 vector) {
        this.scale(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public void scale(Vector3d vector) {
        this.scale(vector.f_86214_, vector.f_86215_, vector.f_86216_);
    }

    public int setShaderTexture(ResourceLocation texture) {
        int previous = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        return previous;
    }

    public int setShaderTexture(int texture) {
        int previous = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157453_((int)0, (int)texture);
        return previous;
    }

    public void setShaderColor(float alpha, float red, float green, float blue) {
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void setShaderColor(int alpha, int red, int green, int blue) {
        this.setShaderColor((float)alpha / 255.0f, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public void setShaderColor(int color) {
        this.setShaderColor(color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public void setShaderColor(ChatFormatting formatting) {
        this.setShaderColor(formatting.m_126665_() == null ? 0xFFFFFF : formatting.m_126665_());
    }

    public void blit(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        GuiComponent.m_93133_((PoseStack)this.matrices, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    public void renderText(Component text, float x, float y, boolean centeredX, boolean centeredY) {
        float f;
        float offsetX;
        FormattedCharSequence formatted = (FormattedCharSequence)this.font.m_92923_((FormattedText)text, 9000).get(0);
        float f2 = offsetX = centeredX ? (float)((double)(-this.font.m_92724_(formatted)) / 2.0) : 0.0f;
        if (centeredY) {
            Objects.requireNonNull(this.font);
            f = (float)((double)(-9) / 2.0);
        } else {
            f = 0.0f;
        }
        float offsetY = f;
        this.font.m_92733_(formatted, x + offsetX, y + offsetY, 0xFFFFFF, false, this.matrices.m_85850_().m_85861_(), (MultiBufferSource)this.bufferSource, true, 0, 0xF000F0);
        RenderSystem.m_69482_();
        this.bufferSource.m_109911_();
    }

    public void renderTextRight(Component text, float x, float y, boolean centeredY) {
        float f;
        FormattedCharSequence formatted = (FormattedCharSequence)this.font.m_92923_((FormattedText)text, 9000).get(0);
        float offsetX = -this.font.m_92724_(formatted);
        if (centeredY) {
            Objects.requireNonNull(this.font);
            f = (float)((double)(-9) / 2.0);
        } else {
            f = 0.0f;
        }
        float offsetY = f;
        this.font.m_92733_(formatted, x + offsetX, y + offsetY, 0xFFFFFF, false, this.matrices.m_85850_().m_85861_(), (MultiBufferSource)this.bufferSource, true, 0, 0xF000F0);
        RenderSystem.m_69482_();
        this.bufferSource.m_109911_();
    }
}

