/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.source;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EntityTaskSource
extends TaskSource {
    private RandomSource random;
    private final Set<UUID> uuids;

    protected EntityTaskSource(RandomSource random) {
        this.random = random;
        this.uuids = new HashSet<UUID>();
    }

    public static EntityTaskSource empty() {
        return new EntityTaskSource(JavaRandom.ofNanoTime());
    }

    public static EntityTaskSource of(RandomSource random, UUID ... uuids) {
        return new EntityTaskSource(random).add(uuids);
    }

    public static EntityTaskSource of(RandomSource random, Entity ... entities) {
        return new EntityTaskSource(random).add(entities);
    }

    public EntityTaskSource add(UUID ... uuids) {
        this.uuids.addAll(Arrays.asList(uuids));
        return this;
    }

    public EntityTaskSource add(Entity ... entities) {
        for (Entity entity : entities) {
            this.uuids.add(entity.m_142081_());
        }
        return this;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    public <T extends Entity> Set<T> getEntities(Class<T> filter) {
        return this.getEntities(ServerLifecycleHooks.getCurrentServer(), filter);
    }

    public <T extends Entity> Set<T> getEntities(MinecraftServer server, Class<T> filter) {
        return this.uuids.stream().map(uuid -> {
            ServerPlayer player = server.m_6846_().m_11259_(uuid);
            if (player != null && filter.isAssignableFrom(player.getClass())) {
                return player;
            }
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (entity == null || !filter.isAssignableFrom(entity.getClass())) continue;
                return entity;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean matches(UUID uuid) {
        return this.uuids.contains(uuid);
    }

    public boolean matches(Entity entity) {
        return this.uuids.contains(entity.m_142081_());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.RANDOM.writeBits(this.random, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.uuids.size(), buffer);
        for (UUID uuid : this.uuids) {
            Adapters.UUID.writeBits(uuid, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.random = (RandomSource)Adapters.RANDOM.readBits(buffer).orElseThrow();
        this.uuids.clear();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            this.uuids.add(Adapters.UUID.readBits(buffer).orElseThrow());
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            nbt.m_128365_("random", Adapters.RANDOM.writeNbt(this.random).orElseThrow());
            ListTag uuids = new ListTag();
            for (UUID uuid : this.uuids) {
                Adapters.UUID.writeNbt(uuid).ifPresent(arg_0 -> uuids.add(arg_0));
            }
            nbt.m_128365_("uuids", (Tag)uuids);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.random = (RandomSource)Adapters.RANDOM.readNbt(nbt.m_128423_("random")).orElseThrow();
        this.uuids.clear();
        ListTag uuids = (ListTag)nbt.m_128423_("uuids");
        for (int i = 0; i < (uuids == null ? 0 : uuids.size()); ++i) {
            Adapters.UUID.readNbt(uuids.get(i)).ifPresent(this.uuids::add);
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            json.add("random", Adapters.RANDOM.writeJson(this.random).orElseThrow());
            JsonArray uuids = new JsonArray();
            for (UUID uuid : this.uuids) {
                Adapters.UUID.writeJson(uuid).ifPresent(arg_0 -> ((JsonArray)uuids).add(arg_0));
            }
            json.add("uuids", (JsonElement)uuids);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.random = (RandomSource)Adapters.RANDOM.readJson(json.get("random")).orElseThrow();
        this.uuids.clear();
        JsonArray uuids = json.getAsJsonArray("uuids");
        for (int i = 0; i < (uuids == null ? 0 : uuids.size()); ++i) {
            Adapters.UUID.readJson(uuids.get(i)).ifPresent(this.uuids::add);
        }
    }
}

