/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BlockHelper {
    public static Iterable<BlockPos> getSpherePositions(BlockPos center, float radius) {
        return BlockHelper.getEllipsoidPositions(center, radius, radius, radius);
    }

    public static int withSpherePositions(BlockPos center, float radius, Consumer<BlockPos> consumer) {
        return BlockHelper.withEllipsoidPositions(center, radius, radius, radius, consumer);
    }

    public static Iterable<BlockPos> getEllipsoidPositions(BlockPos center, float radiusX, float radiusY, float radiusZ) {
        Stack<BlockPos> positions = new Stack<BlockPos>();
        BlockHelper.withEllipsoidPositions(center, radiusX, radiusY, radiusZ, positions::add);
        return positions;
    }

    public static int withEllipsoidPositions(BlockPos center, float radiusX, float radiusY, float radiusZ, Consumer<BlockPos> consumer) {
        int count = 0;
        int rx = Mth.m_14167_((float)radiusX);
        int ry = Mth.m_14167_((float)radiusY);
        int rz = Mth.m_14167_((float)radiusZ);
        for (int x = -rx; x <= rx; ++x) {
            for (int y = -ry; y <= ry; ++y) {
                for (int z = -rz; z <= rz; ++z) {
                    double xa = (double)x / (double)rx;
                    double ya = (double)y / (double)ry;
                    double za = (double)z / (double)rz;
                    if (!(xa * xa + ya * ya + za * za < 1.0)) continue;
                    consumer.accept(new BlockPos(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z));
                    ++count;
                }
            }
        }
        return count;
    }

    public static int withVerticalCylinderPositions(BlockPos center, float radiusX, float height, float radiusZ, Consumer<BlockPos> consumer) {
        int count = 0;
        int rx = Mth.m_14167_((float)radiusX);
        int ry = Mth.m_14167_((float)height);
        int rz = Mth.m_14167_((float)radiusZ);
        for (int x = -rx; x <= rx; ++x) {
            for (int y = -ry; y <= ry; ++y) {
                for (int z = -rz; z <= rz; ++z) {
                    double xa = (double)x / (double)rx;
                    double za = (double)z / (double)rz;
                    if (!(xa * xa + za * za < 1.0)) continue;
                    consumer.accept(new BlockPos(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z));
                    ++count;
                }
            }
        }
        return count;
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }
}

