/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.VaultMod;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.entity.PartialEntityGroup;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.TextComponentUtils;
import iskallia.vault.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EntityGroupsUtils {
    public static final HashMap<EntityPredicate, Set<EntityType<?>>> GROUPED_TYPES = new HashMap();
    private static boolean isSetup = false;

    @SubscribeEvent
    public static void setup(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (isSetup) {
            return;
        }
        EntityGroupsUtils.loadDescriptions();
        isSetup = true;
    }

    private static void loadDescriptions() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        List<Entity> entities = EntityGroupsUtils.createAllEntities(level);
        Map<ResourceLocation, Set<EntityPredicate>> groups = ModConfigs.ENTITY_GROUPS.getGroups();
        for (ResourceLocation group : groups.keySet()) {
            HashSet<EntityType> types = new HashSet<EntityType>();
            for (Entity entity : entities) {
                if (!ModConfigs.ENTITY_GROUPS.isInGroup(group, entity)) continue;
                types.add(entity.m_6095_());
            }
            GROUPED_TYPES.put(PartialEntityGroup.of(group, PartialCompoundNbt.empty()), types);
        }
    }

    private static List<Entity> createAllEntities(ClientLevel level) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Collection entityTypes = ForgeRegistries.ENTITIES.getValues();
        for (EntityType entityType : entityTypes) {
            Entity entity = entityType.m_20615_((Level)level);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            entities.add((Entity)living);
        }
        return entities;
    }

    public static Set<String> getDescriptions(EntityPredicate filter) {
        PartialEntity partialEntity;
        Optional<CompoundTag> whole;
        if (filter instanceof PartialEntity && (whole = (partialEntity = (PartialEntity)filter).getNbt().asWhole()).isPresent()) {
            String id = whole.get().m_128461_("id");
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            return type == null ? Set.of() : Set.of(type.m_20676_().getString());
        }
        return GROUPED_TYPES.getOrDefault(filter, Set.of()).stream().map(entityType -> entityType.m_20676_().getString()).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Component getName(EntityPredicate filter) {
        PartialEntity entity;
        Optional<CompoundTag> whole;
        if (filter instanceof PartialEntityGroup) {
            PartialEntityGroup group = (PartialEntityGroup)filter;
            if (group.getId().m_135815_().equalsIgnoreCase("fighter")) {
                return new TextComponent("Dweller");
            }
            return TextUtil.formatLocationPathAsProperNoun(group.getId());
        }
        if (filter instanceof PartialEntity && (whole = (entity = (PartialEntity)filter).getNbt().asWhole()).isPresent()) {
            String id = whole.get().m_128461_("id");
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            return type == null ? Component.m_130674_((String)"Entities") : type.m_20676_();
        }
        return Component.m_130674_((String)"");
    }

    public static List<Component> getGroupNames() {
        return GROUPED_TYPES.keySet().stream().map(EntityGroupsUtils::getName).sorted(TextComponentUtils.componentComparator()).toList();
    }

    public static Optional<EntityPredicate> getByName(String groupName) {
        groupName = groupName.toLowerCase().replace(' ', '_');
        ResourceLocation groupId = VaultMod.id(groupName.toLowerCase());
        if (groupName.equalsIgnoreCase("dweller")) {
            groupId = VaultMod.id("fighter");
        }
        for (EntityPredicate predicate : GROUPED_TYPES.keySet()) {
            PartialEntityGroup group;
            if (!(predicate instanceof PartialEntityGroup) || !groupId.equals((Object)(group = (PartialEntityGroup)predicate).getId())) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static Optional<EntityPredicate> getByName(ResourceLocation groupId) {
        for (EntityPredicate predicate : GROUPED_TYPES.keySet()) {
            PartialEntityGroup group;
            if (!(predicate instanceof PartialEntityGroup) || !groupId.equals((Object)(group = (PartialEntityGroup)predicate).getId())) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static List<EntityType<?>> getTypes(ResourceLocation groupId) {
        Set types = GROUPED_TYPES.getOrDefault(PartialEntityGroup.of(groupId, PartialCompoundNbt.empty()), Set.of());
        Comparator entityTypeComparator = (o1, o2) -> {
            Comparator<String> stringComparator = Comparator.naturalOrder();
            return stringComparator.compare(o1.m_20676_().getString(), o2.m_20676_().getString());
        };
        return types.stream().sorted(entityTypeComparator).toList();
    }
}

