/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.common.collect.Streams;
import iskallia.vault.VaultMod;
import iskallia.vault.entity.champion.ChampionLogic;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.AABBHelper;
import iskallia.vault.util.MathUtilities;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class EntityHelper {
    private static final AABB BOX = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static int CHAMPION_COUNT = 30;
    public static int DUNGEON_COUNT = 10;
    public static int GUARDIAN_COUNT = 7;
    public static int TANK_COUNT = 10;
    public static int ASSASSIN_COUNT = 3;
    public static int HORDE_COUNT = 1;

    public static void changeHealth(LivingEntity entity, int healthChange) {
        float health = entity.m_21223_();
        entity.m_21153_(health + (float)healthChange);
        if (entity.m_21224_()) {
            entity.m_6667_(entity.m_21225_() != null ? entity.m_21225_() : DamageSource.f_19318_);
        }
    }

    public static void knockback(LivingEntity target, LivingEntity source) {
        double xDiff = source.m_20185_() - target.m_20185_();
        double zDiff = source.m_20189_() - target.m_20189_();
        while (xDiff * xDiff + zDiff * zDiff < 1.0E-4) {
            xDiff = (Math.random() - Math.random()) * 0.01;
            zDiff = (Math.random() - Math.random()) * 0.01;
        }
        target.f_20918_ = (float)(Mth.m_14136_((double)zDiff, (double)xDiff) * 57.29577951308232 - (double)target.m_146908_());
        target.m_147240_(1.0, xDiff, zDiff);
    }

    public static void knockbackIgnoreResist(LivingEntity target, LivingEntity source, float strength) {
        if (target == null || source == null) {
            return;
        }
        double xDiff = source.m_20185_() - target.m_20185_();
        double zDiff = source.m_20189_() - target.m_20189_();
        while (xDiff * xDiff + zDiff * zDiff < 1.0E-4) {
            xDiff = (Math.random() - Math.random()) * 0.01;
            zDiff = (Math.random() - Math.random()) * 0.01;
        }
        target.f_20918_ = (float)(Mth.m_14136_((double)zDiff, (double)xDiff) * 57.29577951308232 - (double)target.m_146908_());
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)target, (float)strength, (double)xDiff, (double)zDiff);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        xDiff = event.getRatioX();
        zDiff = event.getRatioZ();
        target.f_19812_ = true;
        Vec3 vec3 = target.m_20184_();
        Vec3 vec31 = new Vec3(xDiff, 0.0, zDiff).m_82541_().m_82490_((double)strength);
        target.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, target.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + (double)strength) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
    }

    public static void knockbackWithStrength(LivingEntity target, LivingEntity source, float strength) {
        double xDiff = source.m_20185_() - target.m_20185_();
        double zDiff = source.m_20189_() - target.m_20189_();
        while (xDiff * xDiff + zDiff * zDiff < 1.0E-4) {
            xDiff = (Math.random() - Math.random()) * 0.01;
            zDiff = (Math.random() - Math.random()) * 0.01;
        }
        target.f_20918_ = (float)(Mth.m_14136_((double)zDiff, (double)xDiff) * 57.29577951308232 - (double)target.m_146908_());
        target.m_147240_((double)strength, xDiff, zDiff);
    }

    public static <T extends Entity> T changeSize(T entity, float size, Runnable callback) {
        EntityHelper.changeSize(entity, size);
        callback.run();
        return entity;
    }

    public static <T extends Entity> T changeSize(T entity, float size) {
        entity.f_19815_ = entity.m_6972_(Pose.STANDING).m_20388_(size);
        entity.m_6210_();
        return entity;
    }

    public static void giveItem(Player player, ItemStack itemStack) {
        boolean added = player.m_150109_().m_36054_(itemStack);
        if (!added) {
            player.m_7197_(itemStack, false, false);
        }
    }

    public static <T extends Entity> List<T> getNearby(LevelAccessor world, Vec3i pos, float radius, Class<T> entityClass) {
        AABB selectBox = BOX.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82400_((double)radius);
        return world.m_6443_(entityClass, selectBox, entity -> entity.m_6084_() && !entity.m_5833_());
    }

    public static boolean isColliding(Entity entity) {
        return EntityHelper.isColliding(entity.m_183503_(), entity.m_142469_());
    }

    public static boolean isColliding(Level level, AABB boundingBox) {
        return Streams.stream((Iterable)level.m_186431_(null, boundingBox)).findAny().isPresent();
    }

    public static void getEntitiesInRange(LevelAccessor levelAccessor, Vec3 center, float range, Predicate<Entity> filter, List<LivingEntity> result) {
        EntityHelper.getEntitiesInRange(levelAccessor, AABBHelper.create(center, range + 4.0f), center, range, filter, result);
    }

    public static void getEntitiesInRange(LevelAccessor levelAccessor, AABB area, Vec3 center, float range, Predicate<Entity> filter, List<LivingEntity> result) {
        if (levelAccessor == null) {
            return;
        }
        List entityList = levelAccessor.m_6249_((Entity)null, area, filter);
        for (Entity entity : entityList) {
            if (!MathUtilities.isAABBIntersectingOrInsideSphere(entity.m_142469_(), center, range)) continue;
            result.add((LivingEntity)entity);
        }
    }

    public static int getEntityValue(LivingEntity livingEntity) {
        if (ChampionLogic.isChampion(livingEntity)) {
            return CHAMPION_COUNT;
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("dungeon"), (Entity)livingEntity)) {
            return DUNGEON_COUNT;
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("guardian"), (Entity)livingEntity)) {
            return GUARDIAN_COUNT;
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("tank"), (Entity)livingEntity)) {
            return TANK_COUNT;
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("assassin"), (Entity)livingEntity)) {
            return ASSASSIN_COUNT;
        }
        if (ModConfigs.ENTITY_GROUPS.isInGroup(VaultMod.id("horde"), (Entity)livingEntity)) {
            return HORDE_COUNT;
        }
        return 1;
    }
}

