/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.integration.IntegrationSB;
import iskallia.vault.item.BasicScavengerItem;
import iskallia.vault.item.CatalystInhibitorItem;
import iskallia.vault.item.GodBlessingItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class InventoryUtil {
    private static final Set<Function<Player, List<ItemAccess>>> INVENTORY_ACCESS = Set.of(player -> {
        ArrayList<ItemAccess> items = new ArrayList<ItemAccess>();
        Inventory inv = player.m_150109_();
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            items.add(new ItemAccess(stack, newStack -> inv.m_6836_(finalSlot, newStack)));
        }
        return items;
    }, player -> {
        ArrayList items = new ArrayList();
        IntegrationCurios.getCuriosItemStacks((LivingEntity)player).forEach((slot, stackTpl) -> stackTpl.forEach(tpl -> {
            ItemStack stack = (ItemStack)tpl.m_14418_();
            if (stack.m_41619_()) {
                return;
            }
            items.add(new ItemAccess(stack, newStack -> IntegrationCurios.setCurioItemStack((LivingEntity)player, newStack, slot, (Integer)tpl.m_14419_())));
        }));
        return items;
    });
    private static final Set<Function<Player, List<ItemAccess>>> MAIN_HAND_ACCESS = Set.of(player -> {
        ArrayList<ItemAccess> items = new ArrayList<ItemAccess>();
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_()) {
            Inventory inv = player.m_150109_();
            items.add(new ItemAccess(mainHandItem, newStack -> inv.m_6836_(inv.f_35977_, newStack)));
        }
        return items;
    });
    private static final Set<Function<ItemAccess, List<ItemAccess>>> CONTENT_ACCESSORS = Set.of(IntegrationSB::getBackpackItemAccess, InventoryUtil::getShulkerBoxAccess, InventoryUtil::getBundleItemAccess, InventoryUtil::getSatchelItemAccess, InventoryUtil::getSupplementariesSafeAccess, InventoryUtil::getSupplementariesSackAccess, InventoryUtil::getBotaniaBaubleBoxAccess);

    public static List<ItemAccess> findAllItems(Player player) {
        ArrayList<ItemAccess> itemAccesses = new ArrayList<ItemAccess>();
        for (Function<Player, List<ItemAccess>> inventoryFn : INVENTORY_ACCESS) {
            inventoryFn.apply(player).forEach(inventoryStackAccess -> InventoryUtil.discoverContents(inventoryStackAccess, itemAccesses));
        }
        return itemAccesses;
    }

    public static List<ItemAccess> findAllItemsInMainHand(Player player) {
        ArrayList<ItemAccess> itemAccesses = new ArrayList<ItemAccess>();
        for (Function<Player, List<ItemAccess>> mainHandFn : MAIN_HAND_ACCESS) {
            mainHandFn.apply(player).forEach(mainHandStackAccess -> InventoryUtil.discoverContents(mainHandStackAccess, itemAccesses));
        }
        return itemAccesses;
    }

    public static void makeItemsRotten(Player player) {
        List<ItemAccess> itemAccess = InventoryUtil.findAllItems(player);
        for (ItemAccess items : itemAccess) {
            ItemStack stack = items.getStack();
            if (!(stack.m_41720_() instanceof BasicScavengerItem) && !(stack.m_41720_() instanceof CatalystInhibitorItem) && !(stack.m_41720_() instanceof GodBlessingItem)) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("rotten", true);
            tag.m_128473_("VaultId");
            items.setter.accept(stack);
        }
    }

    public static void makeItemsRotten(List<ItemStack> items) {
        for (ItemStack stack : items) {
            if (!(stack.m_41720_() instanceof BasicScavengerItem) && !(stack.m_41720_() instanceof CatalystInhibitorItem) && !(stack.m_41720_() instanceof GodBlessingItem)) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128379_("rotten", true);
            tag.m_128473_("VaultId");
        }
    }

    private static void discoverContents(ItemAccess access, List<ItemAccess> out) {
        out.add(access);
        for (Function<ItemAccess, List<ItemAccess>> containerAccess : CONTENT_ACCESSORS) {
            containerAccess.apply(access).forEach(containedAccess -> InventoryUtil.discoverContents(containedAccess, out));
        }
    }

    public static List<ItemStack> findAllItems(List<ItemStack> items) {
        ArrayList<ItemAccess> itemAccesses = new ArrayList<ItemAccess>();
        for (ItemStack stack : items) {
            ItemAccess readOnlyStack = new ItemAccess(stack);
            itemAccesses.add(readOnlyStack);
            for (Function<ItemAccess, List<ItemAccess>> containerAccess : CONTENT_ACCESSORS) {
                containerAccess.apply(readOnlyStack).forEach(containedAccess -> InventoryUtil.discoverContents(containedAccess, itemAccesses));
            }
        }
        return itemAccesses.stream().map(ItemAccess::getStack).collect(Collectors.toList());
    }

    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory) {
        return InventoryUtil.getMissingInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY);
    }

    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory containerInventory) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            for (OverSizedItemStack overSized : containerInventory.getOverSizedContents()) {
                if (!InventoryUtil.isEqualCrafting(input, overSized.stack())) continue;
                neededCount -= overSized.amount();
            }
            for (ItemStack plStack : playerInventory.f_35974_) {
                if (!InventoryUtil.isEqualCrafting(input, plStack)) continue;
                neededCount -= plStack.m_41613_();
            }
            if (neededCount <= 0) continue;
            missing.add(input);
        }
        return missing;
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, boolean simulate) {
        return InventoryUtil.consumeInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY, simulate);
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory tileInv, boolean simulate) {
        return InventoryUtil.consumeInputs(recipeInputs, playerInventory, tileInv, simulate, new ArrayList<OverSizedItemStack>());
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, boolean simulate, List<OverSizedItemStack> consumed) {
        return InventoryUtil.consumeInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY, simulate, consumed);
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory tileInv, boolean simulate, List<OverSizedItemStack> consumed) {
        boolean success = true;
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            NonNullList<OverSizedItemStack> overSizedContents = tileInv.getOverSizedContents();
            for (int slot = 0; slot < overSizedContents.size(); ++slot) {
                OverSizedItemStack overSized = (OverSizedItemStack)overSizedContents.get(slot);
                if (neededCount <= 0) break;
                if (!InventoryUtil.isEqualCrafting(input, overSized.stack())) continue;
                int deductedAmount = Math.min(neededCount, overSized.amount());
                if (!simulate) {
                    tileInv.setOverSizedStack(slot, overSized.addCopy(-deductedAmount));
                    consumed.add(overSized.copyAmount(deductedAmount));
                }
                neededCount -= overSized.amount();
            }
            NonNullList items = playerInventory.f_35974_;
            for (ItemStack plStack : items) {
                if (neededCount <= 0) break;
                if (!InventoryUtil.isEqualCrafting(input, plStack)) continue;
                int deductedAmount = Math.min(neededCount, plStack.m_41613_());
                if (!simulate) {
                    plStack.m_41774_(deductedAmount);
                    ItemStack deducted = plStack.m_41777_();
                    deducted.m_41764_(deductedAmount);
                    consumed.add(OverSizedItemStack.of(deducted));
                }
                neededCount -= deductedAmount;
            }
            if (neededCount <= 0) continue;
            success = false;
        }
        return success;
    }

    private static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return thisStack.m_41720_() == thatStack.m_41720_() && thisStack.m_41773_() == thatStack.m_41773_() && (thisStack.m_41783_() == null || thisStack.areShareTagsEqual(thatStack));
    }

    private static List<ItemAccess> getBotaniaBaubleBoxAccess(ItemAccess containerAccess) {
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        ItemStack container = containerAccess.getStack();
        if ("botania:bauble_box".equals(container.m_41720_().getRegistryName().toString()) && container.m_41782_()) {
            ListTag itemList = container.m_41784_().m_128437_("Items", 10);
            for (int slot = 0; slot < itemList.size(); ++slot) {
                ItemStack storedItem = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(slot));
                if (storedItem.m_41619_()) continue;
                int finalSlot = slot;
                accesses.add(containerAccess.chain(storedItem, (containerCt, newStack) -> {
                    ListTag containerList = containerCt.m_41784_().m_128437_("Items", 10);
                    CompoundTag newItemTag = new CompoundTag();
                    newStack.m_41739_(newItemTag);
                    containerList.set(finalSlot, (Tag)newItemTag);
                    containerCt.m_41784_().m_128365_("Items", (Tag)containerList);
                }));
            }
        }
        return accesses;
    }

    private static List<ItemAccess> getSupplementariesSackAccess(ItemAccess containerAccess) {
        CompoundTag tag;
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        ItemStack container = containerAccess.getStack();
        if ("supplementaries:sack".equals(container.m_41720_().getRegistryName().toString()) && container.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)container)) != null) {
            NonNullList contents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)contents);
            for (int slot = 0; slot < contents.size(); ++slot) {
                ItemStack stack = (ItemStack)contents.get(slot);
                if (stack.m_41619_()) continue;
                int finalSlot = slot;
                accesses.add(containerAccess.chain(stack, (containerStack, newStack) -> {
                    NonNullList ctContents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
                    CompoundTag ctTag = BlockItem.m_186336_((ItemStack)containerStack);
                    if (ctTag != null) {
                        ContainerHelper.m_18980_((CompoundTag)ctTag, (NonNullList)ctContents);
                        ctContents.set(finalSlot, newStack);
                        ContainerHelper.m_18973_((CompoundTag)ctTag, (NonNullList)ctContents);
                        containerStack.m_41700_("BlockEntityTag", (Tag)ctTag);
                    }
                }));
            }
        }
        return accesses;
    }

    private static List<ItemAccess> getSupplementariesSafeAccess(ItemAccess containerAccess) {
        CompoundTag tag;
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        ItemStack container = containerAccess.getStack();
        if ("supplementaries:safe".equals(container.m_41720_().getRegistryName().toString()) && container.m_41782_() && (tag = BlockItem.m_186336_((ItemStack)container)) != null) {
            NonNullList contents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)contents);
            for (int slot = 0; slot < contents.size(); ++slot) {
                ItemStack stack = (ItemStack)contents.get(slot);
                if (stack.m_41619_()) continue;
                int finalSlot = slot;
                accesses.add(containerAccess.chain(stack, (containerStack, newStack) -> {
                    NonNullList ctContents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                    CompoundTag ctTag = BlockItem.m_186336_((ItemStack)containerStack);
                    if (ctTag != null) {
                        ContainerHelper.m_18980_((CompoundTag)ctTag, (NonNullList)ctContents);
                        ctContents.set(finalSlot, newStack);
                        ContainerHelper.m_18973_((CompoundTag)ctTag, (NonNullList)ctContents);
                        containerStack.m_41700_("BlockEntityTag", (Tag)ctTag);
                    }
                }));
            }
        }
        return accesses;
    }

    private static List<ItemAccess> getSatchelItemAccess(ItemAccess containerAccess) {
        CompoundTag invTag;
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        ItemStack container = containerAccess.getStack();
        if ("thermal:satchel".equals(container.m_41720_().getRegistryName().toString()) && container.m_41782_() && (invTag = container.m_41698_("ItemInv")).m_128425_("ItemInv", 9)) {
            ListTag list = invTag.m_128437_("ItemInv", 10);
            for (int slot = 0; slot < list.size(); ++slot) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(slot));
                if (stack.m_41619_()) continue;
                int finalSlot = slot;
                accesses.add(containerAccess.chain(stack, (containerCt, newStack) -> {
                    CompoundTag newInvTag = container.m_41698_("ItemInv");
                    ListTag invList = newInvTag.m_128437_("ItemInv", 10);
                    CompoundTag newItemTag = new CompoundTag();
                    newStack.m_41739_(newItemTag);
                    invList.set(finalSlot, (Tag)newItemTag);
                    newInvTag.m_128365_("ItemInv", (Tag)invList);
                }));
            }
        }
        return accesses;
    }

    private static List<ItemAccess> getBundleItemAccess(ItemAccess containerAccess) {
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        ItemStack container = containerAccess.getStack();
        if (container.m_41720_() instanceof BundleItem && container.m_41782_()) {
            CompoundTag tag = container.m_41784_();
            ListTag itemList = tag.m_128437_("Items", 10);
            for (int slot = 0; slot < itemList.size(); ++slot) {
                CompoundTag itemTag = itemList.m_128728_(slot);
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (itemStack.m_41619_()) continue;
                int finalSlot = slot;
                accesses.add(containerAccess.chain(itemStack, (containerCt, newStack) -> {
                    CompoundTag newTag = containerCt.m_41784_();
                    ListTag newItemList = newTag.m_128437_("Items", 10);
                    CompoundTag newItemTag = new CompoundTag();
                    newStack.m_41739_(newItemTag);
                    newItemList.set(finalSlot, (Tag)newItemTag);
                    newTag.m_128365_("Items", (Tag)newItemList);
                }));
            }
            return accesses;
        }
        return accesses;
    }

    private static List<ItemAccess> getShulkerBoxAccess(ItemAccess containerAccess) {
        CompoundTag tag;
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        ItemStack container = containerAccess.getStack();
        if (InventoryUtil.isShulkerBox(containerAccess.getStack().m_41720_()) && (tag = BlockItem.m_186336_((ItemStack)container)) != null) {
            NonNullList contents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)contents);
            for (int slot = 0; slot < contents.size(); ++slot) {
                ItemStack stack = (ItemStack)contents.get(slot);
                if (stack.m_41619_()) continue;
                int finalSlot = slot;
                accesses.add(containerAccess.chain(stack, (containerStack, newStack) -> {
                    NonNullList ctContents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                    CompoundTag ctTag = BlockItem.m_186336_((ItemStack)containerStack);
                    if (ctTag != null) {
                        ContainerHelper.m_18980_((CompoundTag)ctTag, (NonNullList)ctContents);
                        ctContents.set(finalSlot, newStack);
                        ContainerHelper.m_18973_((CompoundTag)ctTag, (NonNullList)ctContents);
                        containerStack.m_41700_("BlockEntityTag", (Tag)ctTag);
                    }
                }));
            }
        }
        return accesses;
    }

    private static boolean isShulkerBox(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock;
    }

    public static class ItemAccess {
        private ItemStack stack;
        private final Consumer<ItemStack> setter;

        public ItemAccess(ItemStack stack) {
            this(stack, newStack -> {});
        }

        public ItemAccess(ItemStack stack, Consumer<ItemStack> setter) {
            this.stack = stack;
            this.setter = setter;
        }

        public ItemAccess chain(ItemStack containedItem, BiConsumer<ItemStack, ItemStack> containedItemSetter) {
            return new ItemAccess(containedItem, newStack -> {
                ItemStack container = this.getStack();
                containedItemSetter.accept(container, (ItemStack)newStack);
                this.setStack(container);
            });
        }

        public ItemStack getStack() {
            return this.stack.m_41777_();
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
            this.setter.accept(stack);
        }
    }
}

