/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class MathUtilities {
    private static final Random rand = new Random();

    public static float randomFloat(float min, float max) {
        if (min >= max) {
            return min;
        }
        return min + rand.nextFloat() * (max - min);
    }

    public static int getRandomInt(int min, int max) {
        if (min >= max) {
            return min;
        }
        return min + rand.nextInt(max - min);
    }

    public static double map(double value, double x0, double y0, double x1, double y1) {
        return x1 + (y1 - x1) * ((value - x0) / (y0 - x0));
    }

    public static double length(Vec2 vec) {
        return Math.sqrt(vec.f_82470_ * vec.f_82470_ + vec.f_82471_ * vec.f_82471_);
    }

    public static double extractYaw(Vec3 vec) {
        return Math.atan2(vec.m_7094_(), vec.m_7096_());
    }

    public static double extractPitch(Vec3 vec) {
        return Math.asin(vec.m_7098_() / vec.m_82553_());
    }

    public static Vec3 rotatePitch(Vec3 vec, float pitch) {
        float f = Mth.m_14089_((float)pitch);
        float f1 = Mth.m_14031_((float)pitch);
        double d0 = vec.m_7096_();
        double d1 = vec.m_7098_() * (double)f + vec.m_7094_() * (double)f1;
        double d2 = vec.m_7094_() * (double)f - vec.m_7098_() * (double)f1;
        return new Vec3(d0, d1, d2);
    }

    public static Vec3 rotateYaw(Vec3 vec, float yaw) {
        float f = Mth.m_14089_((float)yaw);
        float f1 = Mth.m_14031_((float)yaw);
        double d0 = vec.m_7096_() * (double)f + vec.m_7094_() * (double)f1;
        double d1 = vec.m_7098_();
        double d2 = vec.m_7094_() * (double)f - vec.m_7096_() * (double)f1;
        return new Vec3(d0, d1, d2);
    }

    public static Vec3 rotateRoll(Vec3 vec, float roll) {
        float f = Mth.m_14089_((float)roll);
        float f1 = Mth.m_14031_((float)roll);
        double d0 = vec.m_7096_() * (double)f + vec.m_7098_() * (double)f1;
        double d1 = vec.m_7098_() * (double)f - vec.m_7096_() * (double)f1;
        double d2 = vec.m_7094_();
        return new Vec3(d0, d1, d2);
    }

    public static Vec3 getRandomPointOnSphere(double xOrigin, double yOrigin, double zOrigin, double radius, Random random) {
        float theta = (float)(Math.PI * 2 * random.nextDouble());
        double u = 2.0 * random.nextDouble() - 1.0;
        double s = Math.sqrt(1.0 - u * u) * radius;
        return new Vec3(xOrigin + s * (double)Mth.m_14089_((float)theta), yOrigin + s * (double)Mth.m_14031_((float)theta), zOrigin + u * radius);
    }

    public static Vec3 getRandomPointOnCircle(double xOrigin, double yOrigin, double zOrigin, double radius, Random random) {
        float theta = (float)(Math.PI * 2 * random.nextDouble());
        return new Vec3(xOrigin + (double)Mth.m_14089_((float)theta) * radius, yOrigin, zOrigin + (double)Mth.m_14031_((float)theta) * radius);
    }

    public static double getDistance(double x0, double y0, double x1, double y1) {
        return Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
    }

    public static double getDistanceSqr(BlockPos blockPos0, BlockPos blockPos1) {
        return MathUtilities.getDistanceSqr(blockPos0.m_123341_(), blockPos0.m_123342_(), blockPos0.m_123343_(), blockPos1.m_123341_(), blockPos1.m_123342_(), blockPos1.m_123343_());
    }

    public static double getDistanceSqr(double x0, double y0, double z0, double x1, double y1, double z1) {
        return (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0) + (z1 - z0) * (z1 - z0);
    }

    public static boolean isAABBIntersectingOrInsideSphere(AABB aabb, Vec3 sphereCenter, double sphereRadius) {
        return MathUtilities.isAABBIntersectingOrInsideSphere(aabb, sphereCenter.f_82479_, sphereCenter.f_82480_, sphereCenter.f_82481_, sphereRadius);
    }

    public static boolean isAABBIntersectingOrInsideSphere(AABB aabb, double xSphereCenter, double ySphereCenter, double zSphereCenter, double sphereRadius) {
        double dmin = 0.0;
        if (xSphereCenter < aabb.f_82288_) {
            dmin += (xSphereCenter - aabb.f_82288_) * (xSphereCenter - aabb.f_82288_);
        } else if (xSphereCenter > aabb.f_82291_) {
            dmin += (xSphereCenter - aabb.f_82291_) * (xSphereCenter - aabb.f_82291_);
        }
        if (ySphereCenter < aabb.f_82289_) {
            dmin += (ySphereCenter - aabb.f_82289_) * (ySphereCenter - aabb.f_82289_);
        } else if (ySphereCenter > aabb.f_82292_) {
            dmin += (ySphereCenter - aabb.f_82292_) * (ySphereCenter - aabb.f_82292_);
        }
        if (zSphereCenter < aabb.f_82290_) {
            dmin += (zSphereCenter - aabb.f_82290_) * (zSphereCenter - aabb.f_82290_);
        } else if (zSphereCenter > aabb.f_82293_) {
            dmin += (zSphereCenter - aabb.f_82293_) * (zSphereCenter - aabb.f_82293_);
        }
        return dmin <= sphereRadius * sphereRadius;
    }
}

