/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.VaultMod;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.dump.PlayerSnapshotDump;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class PlayerDataSnapshotHelper {
    private static void savePlayerSnapshot(ServerPlayer player) {
        PlayerDataSnapshotHelper.savePlayerSnapshot(player, PlayerDataSnapshotHelper.getSnapshotDirectory());
    }

    private static void savePlayerSnapshot(ServerPlayer sPlayer, File directory) {
        String uuidStr = sPlayer.m_142081_().toString();
        File playerFile = new File(directory, uuidStr + ".json");
        if (!playerFile.exists()) {
            playerFile.delete();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(playerFile));){
            writer.write(PlayerSnapshotDump.createAndSerializeSnapshot(sPlayer));
        }
        catch (IOException exc) {
            VaultMod.LOGGER.error("Error writing player snapshot file: " + sPlayer.m_7755_().getString());
            exc.printStackTrace();
        }
    }

    private static File getSnapshotDirectory() {
        File snapshotDirectory = FMLPaths.GAMEDIR.get().resolve("playerSnapshots").toFile();
        if (!snapshotDirectory.exists()) {
            snapshotDirectory.mkdirs();
        }
        return snapshotDirectory;
    }

    static {
        CommonEvents.LISTENER_JOIN.register(PlayerDataSnapshotHelper.class, data -> data.getListener().getPlayer().ifPresent(PlayerDataSnapshotHelper::savePlayerSnapshot));
    }
}

