/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.init.ModEffects;
import iskallia.vault.world.data.ServerVaults;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerPotionEffectHelper {
    private static final int IMMUNITY_DURATION = 80;
    private static final Map<UUID, Map<MobEffect, Integer>> PLAYER_IMMUNITIES = new HashMap<UUID, Map<MobEffect, Integer>>();

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        PLAYER_IMMUNITIES.forEach((uuid, immunities) -> {
            HashSet keys = new HashSet(immunities.keySet());
            for (MobEffect key : keys) {
                int timeout = (Integer)immunities.get(key);
                if (--timeout <= 0) {
                    immunities.remove(key);
                    continue;
                }
                immunities.put(key, timeout);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onApplyPotionEffect(PotionEvent.PotionApplicableEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)livingEntity;
        if (sPlayer.f_19853_.f_46443_) {
            return;
        }
        if (ServerVaults.get(sPlayer.f_19853_).isEmpty()) {
            return;
        }
        MobEffect effect = event.getPotionEffect().m_19544_();
        if (effect.m_19483_() != MobEffectCategory.HARMFUL || effect == ModEffects.BLEED) {
            return;
        }
        UUID uuid = sPlayer.m_142081_();
        Map immunities = PLAYER_IMMUNITIES.computeIfAbsent(uuid, k -> new HashMap());
        if (immunities.containsKey(event.getPotionEffect().m_19544_())) {
            event.setResult(Event.Result.DENY);
            return;
        }
        immunities.put(event.getPotionEffect().m_19544_(), 80);
    }
}

