/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.mana.LowManaHealingEfficiencyTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerTalentsData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerRecoveryHelper {
    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        LivingEntity healed = event.getEntityLiving();
        if (healed.m_20193_().m_5776_()) {
            return;
        }
        if (!(healed instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)healed;
        float multiplier = 1.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        multiplier += snapshot.getAttributeValue(ModGearAttributes.HEALING_EFFECTIVENESS, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        TalentTree tree = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        for (LowManaHealingEfficiencyTalent talent : tree.getAll(LowManaHealingEfficiencyTalent.class, Skill::isUnlocked)) {
            if (!talent.shouldGetBenefits((LivingEntity)player)) continue;
            multiplier += talent.getAdditionalHealingEfficiency();
        }
        multiplier = CommonEvents.PLAYER_STAT.invoke(PlayerStat.HEALING_EFFECTIVENESS, (LivingEntity)player, multiplier).getValue();
        event.setAmount(event.getAmount() * Math.max(0.0f, multiplier));
    }
}

