/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.VaultMod;
import iskallia.vault.config.PlayerResearchTransferConfig;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.world.data.PlayerResearchesData;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerResearchTransferUtil {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerResearchTransferConfig config = ModConfigs.PLAYER_RESEARCH_TRANSFER;
        PlayerResearchesData data = PlayerResearchesData.get(player2.m_183503_());
        ResearchTree researches = data.getResearches((Player)player2);
        List<String> toRemove = researches.getResearchesDone().stream().filter(config.getRemovedResearches()::contains).toList();
        for (String oldResearch : toRemove) {
            Optional<String> newResearchOptional = config.getNewResearch(oldResearch);
            if (newResearchOptional.isEmpty()) {
                VaultMod.LOGGER.debug("Attempted to remove [{}] but found no new research to replace it with.", (Object)oldResearch);
                continue;
            }
            String newResearch = newResearchOptional.get();
            Research remove = ModConfigs.RESEARCHES.getByName(oldResearch);
            if (remove == null) {
                VaultMod.LOGGER.debug("Attempted to remove [{}] but found no registered research with that name.", (Object)oldResearch);
                continue;
            }
            Research add = ModConfigs.RESEARCHES.getByName(newResearch);
            if (add == null) {
                VaultMod.LOGGER.debug("Attempted to remove [{}] but found no registered research with the new name [{}].", (Object)oldResearch, (Object)newResearch);
                continue;
            }
            data.removeResearch(player2, remove);
            data.research(player2, add);
            VaultMod.LOGGER.debug("Removed research [{}] and replaced it with [{}].", (Object)oldResearch, (Object)newResearch);
            player2.m_6352_((Component)new TextComponent("Due to necessary changes in the pack you have had the research [").m_130946_(oldResearch).m_130946_("] removed and [").m_130946_(newResearch).m_130946_("] added in its place.").m_130940_(ChatFormatting.AQUA), Util.f_137441_);
        }
    }
}

