/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class ReservoirSampleHelper {
    private static final Random RANDOM = new Random();

    public static <T> List<T> sample(Iterable<T> iterable) {
        return ReservoirSampleHelper.sample(iterable, 1, RANDOM, new ArrayList(1));
    }

    public static <T> List<T> sample(Iterable<T> iterable, int count) {
        return ReservoirSampleHelper.sample(iterable, count, RANDOM, new ArrayList(count));
    }

    public static <T> List<T> sample(Iterable<T> iterable, int count, Random random) {
        return ReservoirSampleHelper.sample(iterable, count, random, new ArrayList(count));
    }

    public static <T> List<T> sample(Iterable<T> iterable, int count, Random random, List<T> result) {
        return ReservoirSampleHelper.sample(iterable.iterator(), count, random, result);
    }

    public static <T> List<T> sample(Iterator<T> iterator) {
        return ReservoirSampleHelper.sample(iterator, 1, RANDOM, new ArrayList(1));
    }

    public static <T> List<T> sample(Iterator<T> iterator, int count) {
        return ReservoirSampleHelper.sample(iterator, count, RANDOM, new ArrayList(count));
    }

    public static <T> List<T> sample(Iterator<T> iterator, int count, Random random) {
        return ReservoirSampleHelper.sample(iterator, count, random, new ArrayList(count));
    }

    public static <T> List<T> sample(Iterator<T> iterator, int count, Random random, List<T> result) {
        if (count <= 0) {
            return result;
        }
        int index = 0;
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (index < count) {
                result.add(element);
            } else {
                int randomIndex = random.nextInt(index + 1);
                if (randomIndex < count) {
                    result.set(randomIndex, element);
                }
            }
            ++index;
        }
        return result;
    }

    public static void main(String[] args) {
        int i;
        Random random = new Random();
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>();
        for (i = 0; i < 100; ++i) {
            list.add(i);
        }
        for (i = 0; i < 1000000; ++i) {
            List<Integer> resultList = ReservoirSampleHelper.sample(list, 1, random, new ArrayList(1));
            for (Integer result : resultList) {
                countMap.merge(result, 1, Integer::sum);
            }
        }
        System.out.println(countMap);
    }

    private ReservoirSampleHelper() {
    }
}

