/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.util.Counter;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.ClientCommandSourceStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TextComponentUtils {
    public static int getLength(Component cmp) {
        return cmp.getString().length();
    }

    public static MutableComponent substring(CommandSourceStack sourceStack, Component cmp, int beginIndex) {
        return TextComponentUtils.substring(sourceStack, cmp, beginIndex, TextComponentUtils.getLength(cmp));
    }

    public static MutableComponent substring(CommandSourceStack sourceStack, Component cmp, int beginIndex, int endIndex) {
        return TextComponentUtils.substringRecursively((Component)TextComponentUtils.resolveAndFlatten(sourceStack, cmp), beginIndex, endIndex, new Counter());
    }

    private static MutableComponent substringRecursively(Component cmp, int beginIndex, int endIndex, Counter cursor) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("substring beginIndex > endIndex");
        }
        if (!(cmp instanceof MutableComponent)) {
            throw new IllegalArgumentException("Non-flattened component passed");
        }
        MutableComponent txt = (MutableComponent)cmp;
        int elementBeginIndex = beginIndex - cursor.getValue();
        int elementEndIndex = endIndex - cursor.getValue();
        if (elementEndIndex <= 0) {
            return new TextComponent("");
        }
        String txtString = txt.m_6111_();
        if (elementBeginIndex >= txtString.length()) {
            cursor.setValue(cursor.getValue() + txtString.length());
            TextComponent result = new TextComponent("");
            for (Component child : cmp.m_7360_()) {
                result.m_7220_((Component)TextComponentUtils.substringRecursively(child, beginIndex, endIndex, cursor));
            }
            return result;
        }
        String txtSlice = txtString.substring(Math.max(elementBeginIndex, 0), Math.min(elementEndIndex, txtString.length()));
        MutableComponent result = new TextComponent(txtSlice).m_130948_(cmp.m_7383_());
        cursor.setValue(cursor.getValue() + txtString.length());
        for (Component child : cmp.m_7360_()) {
            result.m_7220_((Component)TextComponentUtils.substringRecursively(child, beginIndex, endIndex, cursor));
        }
        return result;
    }

    public static MutableComponent replace(CommandSourceStack sourceStack, Component cmp, String replace, Component replaceWith) {
        return TextComponentUtils.replaceRecursively((Component)TextComponentUtils.resolveAndFlatten(sourceStack, cmp), replace, replaceWith);
    }

    private static MutableComponent replaceRecursively(Component cmp, String replace, Component replaceWith) {
        MutableComponent result = new TextComponent("").m_6270_(cmp.m_7383_());
        if (!(cmp instanceof MutableComponent)) {
            throw new IllegalArgumentException("Non-flattened component passed");
        }
        MutableComponent txt = (MutableComponent)cmp;
        String txtString = txt.m_6111_();
        if (txtString.contains(replace)) {
            String[] parts = txtString.split(replace, -1);
            for (int i = 0; i < parts.length; ++i) {
                result.m_7220_((Component)new TextComponent(parts[i]).m_6270_(cmp.m_7383_()));
                if (i + 1 >= parts.length) continue;
                result.m_7220_(replaceWith);
            }
        } else {
            result.m_7220_((Component)cmp.m_6879_().m_6270_(cmp.m_7383_()));
        }
        for (Component child : cmp.m_7360_()) {
            result.m_7220_((Component)TextComponentUtils.replaceRecursively(child, replace, replaceWith));
        }
        return result;
    }

    public static void applyStyle(Component cmp, Style style) {
        if (cmp instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)cmp;
            mutable.m_6270_(style.m_131146_(cmp.m_7383_()));
        }
        cmp.m_7360_().forEach(child -> TextComponentUtils.applyStyle(child, style));
    }

    private static MutableComponent resolveAndFlatten(CommandSourceStack sourceStack, Component cmp) {
        try {
            return TextComponentUtils.resolveFlatten((Component)ComponentUtils.m_130731_((CommandSourceStack)sourceStack, (Component)cmp, null, (int)0));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return new TextComponent("Formatting Error: " + cmp.getString());
        }
    }

    public static CommandSourceStack createSourceStack(LogicalSide side) {
        if (side.isServer()) {
            return TextComponentUtils.createServerSourceStack();
        }
        return TextComponentUtils.createClientSourceStack();
    }

    public static CommandSourceStack createServerSourceStack() {
        ServerLevel overWorld = ServerLifecycleHooks.getCurrentServer().m_129783_();
        return new CommandSourceStack(CommandSource.f_80164_, Vec3.f_82478_, Vec2.f_82462_, overWorld, 2, "", TextComponent.f_131282_, overWorld.m_142572_(), null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static CommandSourceStack createClientSourceStack() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return new ClientCommandSourceStack(CommandSource.f_80164_, Vec3.f_82478_, Vec2.f_82462_, 2, "", TextComponent.f_131282_, null);
        }
        return ClientCommandHandler.getSource();
    }

    private static MutableComponent resolveFlatten(Component cmp) {
        TextComponent result = new TextComponent("");
        cmp.m_7451_((arg_0, arg_1) -> TextComponentUtils.lambda$resolveFlatten$1((MutableComponent)result, arg_0, arg_1), Style.f_131099_);
        return result;
    }

    public static Comparator<Component> componentComparator() {
        return (o1, o2) -> {
            Comparator<String> stringComparator = Comparator.naturalOrder();
            return stringComparator.compare(o1.getString(), o2.getString());
        };
    }

    public static int getWidth(Component component) {
        return TextBorder.DEFAULT_FONT.get().m_92724_(component.m_7532_());
    }

    private static /* synthetic */ Optional lambda$resolveFlatten$1(MutableComponent result, Style style, String content) {
        result.m_7220_((Component)new TextComponent(content).m_130948_(style));
        return Optional.empty();
    }
}

