/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.util.MathUtilities;
import net.minecraft.util.Mth;

public abstract class Tween {
    public static final Tween LINEAR = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c * t / d + b;
        }
    };
    public static final Tween PARABOLIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float p = t / d;
            return (-4.0f * (p - 0.5f) * (p - 0.5f) + 1.0f) * c + b;
        }
    };
    public static final Tween EASE_IN_QUADRATIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c * (t /= d) * t + b;
        }
    };
    public static final Tween EASE_OUT_QUADRATIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return -c * (t /= d) * (t - 2.0f) + b;
        }
    };
    public static final Tween EASE_INOUT_QUADRATIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * t * t + b;
            }
            return -c / 2.0f * ((t -= 1.0f) * (t - 2.0f) - 1.0f) + b;
        }
    };
    public static final Tween EASE_IN_CUBIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c * (t /= d) * t * t + b;
        }
    };
    public static final Tween EASE_OUT_CUBIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            t = t / d - 1.0f;
            return c * (t * t * t + 1.0f) + b;
        }
    };
    public static final Tween EASE_INOUT_CUBIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * t * t * t + b;
            }
            return c / 2.0f * ((t -= 2.0f) * t * t + 2.0f) + b;
        }
    };
    public static final Tween EASE_IN_QUARTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c * (t /= d) * t * t * t + b;
        }
    };
    public static final Tween EASE_OUT_QUARTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            t = t / d - 1.0f;
            return -c * (t * t * t * t - 1.0f) + b;
        }
    };
    public static final Tween EASE_INOUT_QUARTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * t * t * t * t + b;
            }
            return -c / 2.0f * ((t -= 2.0f) * t * t * t - 2.0f) + b;
        }
    };
    public static final Tween EASE_IN_QUINTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c * (t /= d) * t * t * t * t + b;
        }
    };
    public static final Tween EASE_OUT_QUINTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            t = t / d - 1.0f;
            return c * (t * t * t * t * t + 1.0f) + b;
        }
    };
    public static final Tween EASE_INOUT_QUINTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * t * t * t * t * t + b;
            }
            return c / 2.0f * ((t -= 2.0f) * t * t * t * t + 2.0f) + b;
        }
    };
    public static final Tween EASE_IN_SINUSOIDAL = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return -c * Mth.m_14089_((float)(t / d * 1.5707964f)) + c + b;
        }
    };
    public static final Tween EASE_OUT_SINUSOIDAL = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c * Mth.m_14031_((float)(t / d * 1.5707964f)) + b;
        }
    };
    public static final Tween EASE_INOUT_SINUSOIDAL = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return -c / 2.0f * (Mth.m_14089_((float)((float)Math.PI * t / d)) - 1.0f) + b;
        }
    };
    public static final Tween EASE_IN_EXPONENTIAL = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return t == 0.0f ? b : (float)((double)c * Math.pow(2.0, 10.0f * (t / d - 1.0f)) + (double)b);
        }
    };
    public static final Tween EASE_OUT_EXPONENTIAL = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return t == d ? b + c : (float)((double)c * (-Math.pow(2.0, -10.0f * t / d) + 1.0) + (double)b);
        }
    };
    public static final Tween EASE_INOUT_EXPONENTIAL = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            if (t == 0.0f) {
                return b;
            }
            if (t == d) {
                return b + c;
            }
            t /= d / 2.0f;
            if (f < 1.0f) {
                return (float)((double)(c / 2.0f) * Math.pow(2.0, 10.0f * (t - 1.0f)) + (double)b);
            }
            return (float)((double)(c / 2.0f) * (-Math.pow(2.0, -10.0f * (t -= 1.0f)) + 2.0) + (double)b);
        }
    };
    public static final Tween EASE_IN_CIRCLULAR = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return -c * (Mth.m_14116_((float)(1.0f - (t /= d) * t)) - 1.0f) + b;
        }
    };
    public static final Tween EASE_OUT_CIRCLULAR = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            t = t / d - 1.0f;
            return c * Mth.m_14116_((float)(1.0f - t * t)) + b;
        }
    };
    public static final Tween EASE_INOUT_CIRCLULAR = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return -c / 2.0f * (Mth.m_14116_((float)(1.0f - t * t)) - 1.0f) + b;
            }
            return c / 2.0f * (Mth.m_14116_((float)(1.0f - (t -= 2.0f) * t)) + 1.0f) + b;
        }
    };
    public static final Tween EASE_IN_ELASTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d) == 1.0f) {
                return b + c;
            }
            float p = d * 0.3f;
            float s = p / 4.0f;
            return (float)(-((double)c * Math.pow(2.0, 10.0f * (t -= 1.0f)) * (double)Mth.m_14031_((float)((t * d - s) * ((float)Math.PI * 2) / p))) + (double)b);
        }
    };
    public static final Tween EASE_OUT_ELASTIC = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            if (t == 0.0f) {
                return b;
            }
            if ((t /= d) == 1.0f) {
                return b + c;
            }
            float p = d * 0.3f;
            float s = p / 4.0f;
            return (float)((double)c * Math.pow(2.0, -10.0f * t) * (double)Mth.m_14031_((float)((t * d - s) * ((float)Math.PI * 2) / p)) + (double)c + (double)b);
        }
    };
    public static final Tween EASE_IN_BACK = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c * (t /= d) * t * (2.70158f * t - 1.70158f) + b;
        }
    };
    public static final Tween EASE_OUT_BACK = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            t = t / d - 1.0f;
            return c * (t * t * (2.70158f * t + 1.70158f) + 1.0f) + b;
        }
    };
    public static final Tween EASE_INOUT_BACK = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            float s = 1.70158f;
            t /= d / 2.0f;
            if (f < 1.0f) {
                return c / 2.0f * (t * t * (((s *= 1.525f) + 1.0f) * t - s)) + b;
            }
            return c / 2.0f * ((t -= 2.0f) * t * (((s *= 1.525f) + 1.0f) * t + s) + 2.0f) + b;
        }
    };
    public static final Tween EASE_IN_BOUNCE = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            return c - EASE_OUT_BOUNCE.tween(d - t, 0.0f, c, d) + b;
        }
    };
    public static final Tween EASE_OUT_BOUNCE = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            float f;
            t /= d;
            if ((double)f < 0.36363636363636365) {
                return c * (7.5625f * t * t) + b;
            }
            if ((double)t < 0.7272727272727273) {
                return c * (7.5625f * (t -= 0.54545456f) * t + 0.75f) + b;
            }
            if ((double)t < 0.9090909090909091) {
                return c * (7.5625f * (t -= 0.8181818f) * t + 0.9375f) + b;
            }
            return c * (7.5625f * (t -= 0.95454544f) * t + 0.984375f) + b;
        }
    };
    public static final Tween EASE_INOUT_BOUNCE = new Tween(){

        @Override
        public float tween(float t, float b, float c, float d) {
            if (t < d / 2.0f) {
                return EASE_IN_BOUNCE.tween(t * 2.0f, 0.0f, c, d) * 0.5f + b;
            }
            return EASE_OUT_BOUNCE.tween(t * 2.0f - d, 0.0f, c, d) * 0.5f + c * 0.5f + b;
        }
    };

    public abstract float tween(float var1, float var2, float var3, float var4);

    public static InOut inOut(Tween in, Tween out) {
        return new InOut(in, out);
    }

    public static InOut inOut(Tween in, Tween out, float threshold) {
        return new InOut(in, out, threshold);
    }

    public static final float easeInElastic(float t, float b, float c, float d, float a, float p) {
        float s;
        if (t == 0.0f) {
            return b;
        }
        if ((t /= d) == 1.0f) {
            return b + c;
        }
        if (p == 0.0f) {
            p = d * 0.3f;
        }
        if (a < Mth.m_14154_((float)c)) {
            a = c;
            s = p / 4.0f;
        } else {
            s = (float)((double)(p / ((float)Math.PI * 2)) * Math.asin(c / a));
        }
        return (float)(-((double)a * Math.pow(2.0, 10.0f * (t -= 1.0f)) * (double)Mth.m_14031_((float)((t * d - s) * ((float)Math.PI * 2) / p))) + (double)b);
    }

    public static final class InOut
    extends Tween {
        private final Tween in;
        private final Tween out;
        private final float threshold;

        private InOut(Tween in, Tween out) {
            this(in, out, 0.5f);
        }

        private InOut(Tween in, Tween out, float threshold) {
            this.in = in;
            this.out = out;
            this.threshold = Mth.m_14036_((float)threshold, (float)0.0f, (float)1.0f);
        }

        @Override
        public float tween(float t, float b, float c, float d) {
            if (t / d <= this.threshold) {
                return this.in.tween(t, b, c, d * this.threshold);
            }
            t = (float)MathUtilities.map(t, d * this.threshold, d, 0.0, d);
            return this.out.tween(t, b + c, -c, d);
        }
    }
}

