/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.ability.AbilityCooldownFlatAttribute;
import iskallia.vault.gear.attribute.ability.AbilityCooldownPercentAttribute;
import iskallia.vault.gear.attribute.ability.AbilityFloatValueAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModEtchings;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.AttributeLimitHelper;
import iskallia.vault.util.calc.PlayerStat;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class CooldownHelper {
    public static int adjustCooldown(ServerPlayer player, String ability, int cooldownTicks) {
        float cooldownMultiplier = CooldownHelper.getCooldownMultiplier((LivingEntity)player);
        float cooldown = cooldownTicks;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        for (AbilityFloatValueAttribute attribute : snapshot.getAttributeValue(ModGearAttributes.ABILITY_COOLDOWN_FLAT, VaultGearAttributeTypeMerger.asList())) {
            cooldown = ((AbilityCooldownFlatAttribute)attribute).adjustCooldown(ability, cooldown);
        }
        cooldown -= (float)cooldownTicks * cooldownMultiplier;
        for (AbilityFloatValueAttribute attribute : snapshot.getAttributeValue(ModGearAttributes.ABILITY_COOLDOWN_PERCENT, VaultGearAttributeTypeMerger.asList())) {
            cooldown = ((AbilityCooldownPercentAttribute)attribute).adjustCooldown(ability, cooldown);
        }
        if (snapshot.hasEtching(ModEtchings.RIFT)) {
            cooldown *= ModEtchings.RIFT.getCooldownMultiplier();
        }
        return Math.max(Mth.m_14143_((float)cooldown), 0);
    }

    public static float getCooldownMultiplier(LivingEntity player) {
        return Mth.m_14036_((float)CooldownHelper.getCooldownMultiplierUnlimited(player), (float)0.0f, (float)AttributeLimitHelper.getCooldownReductionLimit(player));
    }

    public static float getCooldownMultiplierUnlimited(LivingEntity player) {
        float multiplier = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(player);
        multiplier += snapshot.getAttributeValue(ModGearAttributes.COOLDOWN_REDUCTION, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        multiplier += snapshot.getAttributeValue(ModGearAttributes.COOLDOWN_REDUCTION_PERCENTILE, VaultGearAttributeTypeMerger.floatSum()).floatValue() * multiplier;
        multiplier = CommonEvents.PLAYER_STAT.invoke(PlayerStat.COOLDOWN_REDUCTION, player, multiplier).getValue();
        return multiplier;
    }
}

