/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.client.ClientExpertiseData;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.expertise.type.DivineExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GodAffinityHelper {
    private static final Map<VaultGod, VaultGearAttribute<Float>> GOD_TO_ATTRIBUTE = new HashMap<VaultGod, VaultGearAttribute<Float>>();
    private static final Map<VaultGod, PlayerStat> GOD_TO_STAT = new HashMap<VaultGod, PlayerStat>();

    public static float getAffinityPercent(LivingEntity entity, VaultGod god) {
        float affinity = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        affinity += snapshot.getAttributeValue(GOD_TO_ATTRIBUTE.get((Object)god), VaultGearAttributeTypeMerger.floatSum()).floatValue();
        affinity = CommonEvents.PLAYER_STAT.invoke(GOD_TO_STAT.get((Object)god), entity, affinity).getValue();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ExpertiseTree expertises = PlayerExpertisesData.get(serverPlayer.m_183503_()).getExpertises((Player)serverPlayer);
            float affinityIncrease = 0.0f;
            for (DivineExpertise expertise : expertises.getAll(DivineExpertise.class, Skill::isUnlocked)) {
                affinityIncrease += expertise.getAffinityIncrease();
            }
            affinity += affinityIncrease;
        }
        return affinity;
    }

    public static float getClientIdonaAffinityPercent(LivingEntity entity) {
        float affinity = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        affinity += snapshot.getAttributeValue(GOD_TO_ATTRIBUTE.get((Object)VaultGod.IDONA), VaultGearAttributeTypeMerger.floatSum()).floatValue();
        affinity = CommonEvents.PLAYER_STAT.invoke(GOD_TO_STAT.get((Object)VaultGod.IDONA), entity, affinity).getValue();
        float affinityIncrease = 0.0f;
        for (TieredSkill learnedTalentNode : ClientExpertiseData.getLearnedTalentNodes()) {
            LearnableSkill learnableSkill = learnedTalentNode.getChild();
            if (!(learnableSkill instanceof DivineExpertise)) continue;
            DivineExpertise divineExpertise = (DivineExpertise)learnableSkill;
            affinityIncrease += divineExpertise.getAffinityIncrease();
        }
        return affinity += affinityIncrease;
    }

    public static float getClientTenosAffinityPercent(LivingEntity entity) {
        float affinity = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        affinity += snapshot.getAttributeValue(GOD_TO_ATTRIBUTE.get((Object)VaultGod.TENOS), VaultGearAttributeTypeMerger.floatSum()).floatValue();
        affinity = CommonEvents.PLAYER_STAT.invoke(GOD_TO_STAT.get((Object)VaultGod.TENOS), entity, affinity).getValue();
        float affinityIncrease = 0.0f;
        for (TieredSkill learnedTalentNode : ClientExpertiseData.getLearnedTalentNodes()) {
            LearnableSkill learnableSkill = learnedTalentNode.getChild();
            if (!(learnableSkill instanceof DivineExpertise)) continue;
            DivineExpertise divineExpertise = (DivineExpertise)learnableSkill;
            affinityIncrease += divineExpertise.getAffinityIncrease();
        }
        return affinity += affinityIncrease;
    }

    public static float getClientVelaraAffinityPercent(LivingEntity entity) {
        float affinity = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        affinity += snapshot.getAttributeValue(GOD_TO_ATTRIBUTE.get((Object)VaultGod.VELARA), VaultGearAttributeTypeMerger.floatSum()).floatValue();
        affinity = CommonEvents.PLAYER_STAT.invoke(GOD_TO_STAT.get((Object)VaultGod.VELARA), entity, affinity).getValue();
        float affinityIncrease = 0.0f;
        for (TieredSkill learnedTalentNode : ClientExpertiseData.getLearnedTalentNodes()) {
            LearnableSkill learnableSkill = learnedTalentNode.getChild();
            if (!(learnableSkill instanceof DivineExpertise)) continue;
            DivineExpertise divineExpertise = (DivineExpertise)learnableSkill;
            affinityIncrease += divineExpertise.getAffinityIncrease();
        }
        return affinity += affinityIncrease;
    }

    public static float getClientWendarrAffinityPercent(LivingEntity entity) {
        float affinity = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        affinity += snapshot.getAttributeValue(GOD_TO_ATTRIBUTE.get((Object)VaultGod.WENDARR), VaultGearAttributeTypeMerger.floatSum()).floatValue();
        affinity = CommonEvents.PLAYER_STAT.invoke(GOD_TO_STAT.get((Object)VaultGod.WENDARR), entity, affinity).getValue();
        float affinityIncrease = 0.0f;
        for (TieredSkill learnedTalentNode : ClientExpertiseData.getLearnedTalentNodes()) {
            LearnableSkill learnableSkill = learnedTalentNode.getChild();
            if (!(learnableSkill instanceof DivineExpertise)) continue;
            DivineExpertise divineExpertise = (DivineExpertise)learnableSkill;
            affinityIncrease += divineExpertise.getAffinityIncrease();
        }
        return affinity += affinityIncrease;
    }

    static {
        GOD_TO_ATTRIBUTE.put(VaultGod.VELARA, ModGearAttributes.VELARA_AFFINITY);
        GOD_TO_ATTRIBUTE.put(VaultGod.TENOS, ModGearAttributes.TENOS_AFFINITY);
        GOD_TO_ATTRIBUTE.put(VaultGod.WENDARR, ModGearAttributes.WENDARR_AFFINITY);
        GOD_TO_ATTRIBUTE.put(VaultGod.IDONA, ModGearAttributes.IDONA_AFFINITY);
        GOD_TO_STAT.put(VaultGod.VELARA, PlayerStat.VELARA_AFFINITY);
        GOD_TO_STAT.put(VaultGod.TENOS, PlayerStat.TENOS_AFFINITY);
        GOD_TO_STAT.put(VaultGod.WENDARR, PlayerStat.WENDARR_AFFINITY);
        GOD_TO_STAT.put(VaultGod.IDONA, PlayerStat.IDONA_AFFINITY);
    }
}

