/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PlayerStatisticsMessage;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.VaultSnapshots;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber
public class PlayerStatisticsCollector {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.END || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        if (sPlayer.f_19797_ % 20 != 0) {
            return;
        }
        CompoundTag reputationStats = new CompoundTag();
        for (VaultGod type : VaultGod.values()) {
            reputationStats.m_128405_(type.getName(), PlayerReputationData.getReputation(sPlayer.m_142081_(), type));
        }
        CompoundTag serialized = new CompoundTag();
        serialized.m_128365_("reputation", (Tag)reputationStats);
        PlayerStatisticsMessage pkt = new PlayerStatisticsMessage(serialized);
        ModNetwork.CHANNEL.sendTo((Object)pkt, sPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static class AttributeSnapshot {
        private final String unlocAttributeName;
        private final String parentAttributeName;
        private final double value;
        private final boolean isPercentage;
        private double limit = -1.0;

        public AttributeSnapshot(String unlocAttributeName, double value, boolean isPercentage) {
            this(unlocAttributeName, null, value, isPercentage);
        }

        public AttributeSnapshot(String unlocAttributeName, String parentAttributeName, double value, boolean isPercentage) {
            this.unlocAttributeName = unlocAttributeName;
            this.parentAttributeName = parentAttributeName;
            this.value = value;
            this.isPercentage = isPercentage;
        }

        private AttributeSnapshot setLimit(double limit) {
            this.limit = limit;
            return this;
        }

        public String getAttributeName() {
            return this.unlocAttributeName;
        }

        public String getParentAttributeName() {
            return this.parentAttributeName != null ? this.parentAttributeName : this.getAttributeName();
        }

        public double getValue() {
            return this.value;
        }

        public boolean isPercentage() {
            return this.isPercentage;
        }

        public boolean hasLimit() {
            return this.limit != -1.0;
        }

        public double getLimit() {
            return this.limit;
        }

        public boolean hasHitLimit() {
            return this.hasLimit() && this.getValue() > this.getLimit();
        }

        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("key", this.getAttributeName());
            nbt.m_128359_("parent", this.getParentAttributeName());
            nbt.m_128347_("value", this.getValue());
            nbt.m_128379_("isPercentage", this.isPercentage());
            nbt.m_128347_("limit", this.getLimit());
            return nbt;
        }

        public static AttributeSnapshot deserialize(CompoundTag nbt) {
            return new AttributeSnapshot(nbt.m_128461_("key"), nbt.m_128461_("parent"), nbt.m_128459_("value"), nbt.m_128471_("isPercentage")).setLimit(nbt.m_128459_("limit"));
        }
    }

    public static class VaultRunsSnapshot {
        public int completed;
        public int survived;
        public int failed;
        public int artifacts;

        public static VaultRunsSnapshot ofPlayer(ServerPlayer sPlayer) {
            VaultRunsSnapshot data = new VaultRunsSnapshot();
            for (VaultSnapshot snapshot : VaultSnapshots.getAll()) {
                Vault vault = snapshot.getEnd();
                if (vault == null) continue;
                vault.ifPresent(Vault.STATS, collector -> {
                    StatCollector stats = collector.get(sPlayer.m_142081_());
                    if (stats == null) {
                        return;
                    }
                    switch (stats.get(StatCollector.COMPLETION)) {
                        case COMPLETED: {
                            ++data.completed;
                            break;
                        }
                        case BAILED: {
                            ++data.survived;
                            break;
                        }
                        case FAILED: {
                            ++data.failed;
                        }
                    }
                    for (ItemStack reward : stats.get(StatCollector.REWARD)) {
                        BlockItem blockItem;
                        Block patt3207$temp;
                        Item patt3152$temp = reward.m_41720_();
                        if (!(patt3152$temp instanceof BlockItem) || !((patt3207$temp = (blockItem = (BlockItem)patt3152$temp).m_40614_()) instanceof VaultCrateBlock)) continue;
                        VaultCrateBlock block = (VaultCrateBlock)patt3207$temp;
                        if (reward.m_41783_() == null) continue;
                        CompoundTag tag = reward.m_41784_().m_128469_("BlockEntityTag").m_6426_();
                        tag.m_128359_("id", ModBlocks.VAULT_CRATE_TILE_ENTITY.getRegistryName().toString());
                        BlockEntity te = BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)block.m_49966_(), (CompoundTag)tag);
                        if (te == null) continue;
                        te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                            for (int i = 0; i < handler.getSlots(); ++i) {
                                ItemStack stack = handler.getStackInSlot(i);
                                if (stack.m_41720_() != ModItems.UNIDENTIFIED_ARTIFACT) continue;
                                ++data.artifacts;
                            }
                        });
                    }
                });
            }
            return data;
        }
    }
}

