/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.data;

import com.google.gson.annotations.Expose;
import iskallia.vault.util.data.RandomListAccess;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class WeightedDoubleList<T>
extends AbstractList<Entry<T>>
implements RandomListAccess<T> {
    @Expose
    private final List<Entry<T>> entries = new ArrayList<Entry<T>>();

    public WeightedDoubleList<T> add(T value, double weight) {
        this.add(new Entry<T>(value, weight));
        return this;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Entry<T> get(int index) {
        return this.entries.get(index);
    }

    @Override
    public boolean add(Entry<T> entry) {
        return this.entries.add(entry);
    }

    @Override
    public Entry<T> remove(int index) {
        return this.entries.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.entries.remove(o);
    }

    @Override
    public boolean removeEntry(T t) {
        return this.removeIf((Predicate<? super Entry<T>>)((Predicate<Entry>)entry -> entry.value.equals(t)));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.entries.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super Entry<T>> filter) {
        return this.entries.removeIf(filter);
    }

    public double getTotalWeight() {
        return this.entries.stream().mapToDouble(entry -> entry.weight).sum();
    }

    @Override
    @Nullable
    public T getRandom(Random random) {
        double totalWeight = this.getTotalWeight();
        if (totalWeight <= 0.0) {
            return null;
        }
        return this.getWeightedAt(random.nextDouble() * totalWeight);
    }

    private T getWeightedAt(double weight) {
        for (Entry<T> e : this.entries) {
            if (!((weight -= e.weight) < 0.0)) continue;
            return e.value;
        }
        return null;
    }

    public WeightedDoubleList<T> copy() {
        WeightedDoubleList copy = new WeightedDoubleList();
        this.entries.forEach((? super T entry) -> copy.add(entry.value, entry.weight));
        return copy;
    }

    public WeightedDoubleList<T> copyFiltered(Predicate<T> filter) {
        WeightedDoubleList copy = new WeightedDoubleList();
        this.entries.forEach((? super T entry) -> {
            if (filter.test(entry.value)) {
                copy.add((Entry)entry);
            }
        });
        return copy;
    }

    public boolean containsValue(T value) {
        return this.stream().map(entry -> entry.value).anyMatch(t -> t.equals(value));
    }

    @Override
    public void forEach(BiConsumer<T, Number> weightEntryConsumer) {
        this.forEach((? super T entry) -> weightEntryConsumer.accept(entry.value, entry.weight));
    }

    public static class Entry<T> {
        @Expose
        public T value;
        @Expose
        public double weight;

        public Entry(T value, double weight) {
            this.value = value;
            this.weight = weight;
        }
    }
}

