/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.nbt;

import iskallia.vault.util.nbt.INBTSerializable;
import iskallia.vault.util.nbt.NBTSerialize;
import iskallia.vault.util.nbt.UnserializableClassException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.ArrayUtils;

public class NBTSerializer {
    public static final <T extends INBTSerializable> CompoundTag serialize(T object) throws IllegalAccessException, UnserializableClassException {
        Field[] df;
        CompoundTag t = new CompoundTag();
        Class<?> definition = object.getClass();
        for (Field f : df = definition.getDeclaredFields()) {
            Class<Comparable<Byte>> fc;
            if (!f.isAnnotationPresent(NBTSerialize.class)) continue;
            f.setAccessible(true);
            Object fv = f.get(object);
            if (fv == null) continue;
            String tn = f.getAnnotation(NBTSerialize.class).name();
            if (tn.equals("")) {
                tn = f.getName();
            }
            if ((fc = f.getType()).isAssignableFrom(Byte.TYPE)) {
                t.m_128344_(tn, ((Byte)fv).byteValue());
                continue;
            }
            if (fc.isAssignableFrom(Boolean.TYPE)) {
                t.m_128379_(tn, ((Boolean)fv).booleanValue());
                continue;
            }
            if (fc.isAssignableFrom(Short.TYPE)) {
                t.m_128376_(tn, ((Short)fv).shortValue());
                continue;
            }
            if (fc.isAssignableFrom(Integer.TYPE)) {
                t.m_128405_(tn, ((Integer)fv).intValue());
                continue;
            }
            if (fc.isAssignableFrom(Long.TYPE)) {
                t.m_128356_(tn, ((Long)fv).longValue());
                continue;
            }
            if (fc.isAssignableFrom(Float.TYPE)) {
                t.m_128350_(tn, ((Float)fv).floatValue());
                continue;
            }
            if (fc.isAssignableFrom(Double.TYPE)) {
                t.m_128347_(tn, ((Double)fv).doubleValue());
                continue;
            }
            t.m_128365_(tn, NBTSerializer.objectToTag(fc, fv));
        }
        return t;
    }

    private static final <T, U extends T> Tag objectToTag(Class<T> clazz, U obj) throws IllegalAccessException, UnserializableClassException {
        if (obj == null) {
            return null;
        }
        if (clazz.isAssignableFrom(Byte.class)) {
            return ByteTag.m_128266_((byte)((Byte)obj));
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return ByteTag.m_128266_((byte)((Boolean)obj != false ? (byte)1 : 0));
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return ShortTag.m_129258_((short)((Short)obj));
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return IntTag.m_128679_((int)((Integer)obj));
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return LongTag.m_128882_((long)((Long)obj));
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return FloatTag.m_128566_((float)((Float)obj).floatValue());
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return DoubleTag.m_128500_((double)((Double)obj));
        }
        if (clazz.isAssignableFrom(byte[].class)) {
            return new ByteArrayTag((byte[])obj);
        }
        if (clazz.isAssignableFrom(Byte[].class)) {
            return new ByteArrayTag(ArrayUtils.toPrimitive((Byte[])((Byte[])obj)));
        }
        if (clazz.isAssignableFrom(String.class)) {
            return StringTag.m_129297_((String)((String)obj));
        }
        if (clazz.isAssignableFrom(int[].class)) {
            return new IntArrayTag((int[])obj);
        }
        if (clazz.isAssignableFrom(Integer[].class)) {
            return new IntArrayTag(ArrayUtils.toPrimitive((Integer[])((Integer[])obj)));
        }
        if (INBTSerializable.class.isAssignableFrom(clazz)) {
            return NBTSerializer.serialize((INBTSerializable)obj);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return NBTSerializer.serializeCollection((Collection)obj);
        }
        if (Map.Entry.class.isAssignableFrom(clazz)) {
            return NBTSerializer.serializeEntry((Map.Entry)obj);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return NBTSerializer.serializeCollection(((Map)obj).entrySet());
        }
        throw new UnserializableClassException(clazz);
    }

    private static final <T> ListTag serializeCollection(Collection<T> col) throws IllegalAccessException, UnserializableClassException {
        ListTag c = new ListTag();
        if (col.size() <= 0) {
            return c;
        }
        Class<?> subclass = col.iterator().next().getClass();
        for (T element : col) {
            Tag tag = NBTSerializer.objectToTag(subclass, element);
            if (tag == null) continue;
            c.add((Object)tag);
        }
        return c;
    }

    private static final <K, V> CompoundTag serializeEntry(Map.Entry<K, V> entry) throws UnserializableClassException, IllegalAccessException {
        Class<?> keyClass = entry.getKey().getClass();
        Class<?> valueClass = entry.getValue().getClass();
        return NBTSerializer.serializeEntry(entry, keyClass, valueClass);
    }

    private static final <K, V> CompoundTag serializeEntry(Map.Entry<? extends K, ? extends V> entry, Class<K> keyClass, Class<V> valueClass) throws IllegalAccessException, UnserializableClassException {
        CompoundTag te = new CompoundTag();
        if (entry.getKey() != null) {
            Tag keyTag = NBTSerializer.objectToTag(keyClass, entry.getKey());
            te.m_128365_("k", keyTag);
        }
        if (entry.getValue() != null) {
            Tag valueTag = NBTSerializer.objectToTag(valueClass, entry.getValue());
            te.m_128365_("v", valueTag);
        }
        return te;
    }

    public static final <T extends INBTSerializable> T deserialize(Class<T> definition, CompoundTag data) throws IllegalAccessException, InstantiationException, UnserializableClassException {
        INBTSerializable instance = (INBTSerializable)definition.newInstance();
        NBTSerializer.deserialize(instance, data, true);
        return (T)instance;
    }

    public static final <T extends INBTSerializable> void deserialize(T instance, CompoundTag data, boolean interpretMissingFieldValuesAsNull) throws IllegalAccessException, InstantiationException, UnserializableClassException {
        Field[] df;
        for (Field f : df = instance.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(NBTSerialize.class)) continue;
            String tn = f.getAnnotation(NBTSerialize.class).name();
            if (tn.equals("")) {
                tn = f.getName();
            }
            if (!data.m_128441_(tn)) {
                if (!interpretMissingFieldValuesAsNull) continue;
                f.setAccessible(true);
                if (f.getType().equals(Boolean.TYPE)) {
                    f.set(instance, false);
                    continue;
                }
                if (f.getType().equals(Integer.TYPE)) {
                    f.set(instance, 0);
                    continue;
                }
                f.set(instance, null);
                continue;
            }
            f.setAccessible(true);
            Class<Object> forceInstantiateAs = f.getAnnotation(NBTSerialize.class).typeOverride();
            Class<Object> fc = forceInstantiateAs.isAssignableFrom(Object.class) ? f.getType() : forceInstantiateAs;
            if (fc.isAssignableFrom(Byte.TYPE)) {
                f.setByte(instance, data.m_128445_(tn));
                continue;
            }
            if (fc.isAssignableFrom(Boolean.TYPE)) {
                f.setBoolean(instance, data.m_128471_(tn));
                continue;
            }
            if (fc.isAssignableFrom(Short.TYPE)) {
                f.setShort(instance, data.m_128448_(tn));
                continue;
            }
            if (fc.isAssignableFrom(Integer.TYPE)) {
                f.setInt(instance, data.m_128451_(tn));
                continue;
            }
            if (fc.isAssignableFrom(Long.TYPE)) {
                f.setLong(instance, data.m_128454_(tn));
                continue;
            }
            if (fc.isAssignableFrom(Float.TYPE)) {
                f.setFloat(instance, data.m_128457_(tn));
                continue;
            }
            if (fc.isAssignableFrom(Double.TYPE)) {
                f.setDouble(instance, data.m_128459_(tn));
                continue;
            }
            f.set(instance, NBTSerializer.tagToObject(data.m_128423_(tn), fc, f.getGenericType()));
        }
    }

    private static <T> Collection<T> deserializeCollection(ListTag list, Class<? extends Collection> colClass, Class<T> subclass, Type subtype) throws InstantiationException, IllegalAccessException, UnserializableClassException {
        Collection c = colClass.newInstance();
        for (int i = 0; i < list.size(); ++i) {
            c.add(NBTSerializer.tagToObject(list.get(i), subclass, subtype));
        }
        return c;
    }

    private static <K, V> Map<K, V> deserializeMap(ListTag map, Class<? extends Map> mapClass, Class<K> keyClass, Type keyType, Class<V> valueClass, Type valueType) throws InstantiationException, IllegalAccessException, UnserializableClassException {
        Map e = mapClass.newInstance();
        for (int i = 0; i < map.size(); ++i) {
            CompoundTag kvp = (CompoundTag)map.get(i);
            Object key = kvp.m_128441_("k") ? (Object)NBTSerializer.tagToObject(kvp.m_128423_("k"), keyClass, keyType) : null;
            Object value = kvp.m_128441_("v") ? (Object)NBTSerializer.tagToObject(kvp.m_128423_("v"), valueClass, valueType) : null;
            e.put(key, value);
        }
        return e;
    }

    private static <T> T tagToObject(Tag tag, Class<T> clazz, Type subtype) throws IllegalAccessException, InstantiationException, UnserializableClassException {
        if (clazz.isAssignableFrom(Object.class) || clazz.isAssignableFrom(Number.class) || clazz.isAssignableFrom(CharSequence.class) || clazz.isAssignableFrom(Serializable.class) || clazz.isAssignableFrom(Comparable.class)) {
            throw new UnserializableClassException(clazz);
        }
        if (clazz.isAssignableFrom(Byte.class)) {
            return (T)Byte.valueOf(((ByteTag)tag).m_7063_());
        }
        if (clazz.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(((ByteTag)tag).m_7063_() != 0);
        }
        if (clazz.isAssignableFrom(Short.class)) {
            return (T)Short.valueOf(((ShortTag)tag).m_7053_());
        }
        if (clazz.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(((IntTag)tag).m_7047_());
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(((LongTag)tag).m_7046_());
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return (T)Float.valueOf(((FloatTag)tag).m_7057_());
        }
        if (clazz.isAssignableFrom(Double.class)) {
            return (T)Double.valueOf(((DoubleTag)tag).m_7061_());
        }
        if (clazz.isAssignableFrom(byte[].class)) {
            return (T)((ByteArrayTag)tag).m_128227_();
        }
        if (clazz.isAssignableFrom(Byte[].class)) {
            return (T)ArrayUtils.toObject((byte[])((ByteArrayTag)tag).m_128227_());
        }
        if (clazz.isAssignableFrom(String.class)) {
            return (T)((StringTag)tag).m_7916_();
        }
        if (clazz.isAssignableFrom(int[].class)) {
            return (T)((IntArrayTag)tag).m_128648_();
        }
        if (clazz.isAssignableFrom(Integer[].class)) {
            return (T)ArrayUtils.toObject((int[])((IntArrayTag)tag).m_128648_());
        }
        if (INBTSerializable.class.isAssignableFrom(clazz)) {
            CompoundTag ntc = (CompoundTag)tag;
            return NBTSerializer.deserialize(clazz, ntc);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Type listType = ((ParameterizedType)subtype).getActualTypeArguments()[0];
            Class lct = listType instanceof ParameterizedType ? (Class)((ParameterizedType)listType).getRawType() : (Class)listType;
            ListTag ntl = (ListTag)tag;
            Collection<T> c2 = NBTSerializer.deserializeCollection(ntl, clazz, lct, listType);
            return (T)c2;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Type[] types = ((ParameterizedType)subtype).getActualTypeArguments();
            Type keyType = types[0];
            Type valueType = types[1];
            Class keyClass = keyType instanceof ParameterizedType ? (Class)((ParameterizedType)keyType).getRawType() : (Class)keyType;
            Class valueClass = valueType instanceof ParameterizedType ? (Class)((ParameterizedType)valueType).getRawType() : (Class)valueType;
            ListTag ntl = (ListTag)tag;
            Map c2 = NBTSerializer.deserializeMap(ntl, clazz, keyClass, keyType, valueClass, valueType);
            return (T)c2;
        }
        throw new UnserializableClassException(clazz);
    }

    private static int getIDFromClass(Class<?> clazz) {
        if (clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(Boolean.class)) {
            return 1;
        }
        if (clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(Short.class)) {
            return 2;
        }
        if (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Integer.class)) {
            return 3;
        }
        if (clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Long.class)) {
            return 4;
        }
        if (clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Float.class)) {
            return 5;
        }
        if (clazz.isAssignableFrom(Double.TYPE) || clazz.isAssignableFrom(Double.class)) {
            return 6;
        }
        if (clazz.isAssignableFrom(byte[].class) || clazz.isAssignableFrom(Byte[].class)) {
            return 7;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return 8;
        }
        if (clazz.isAssignableFrom(int[].class) || clazz.isAssignableFrom(Integer[].class)) {
            return 11;
        }
        if (INBTSerializable.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            return 9;
        }
        return 10;
    }
}

