/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.vending;

import com.google.gson.annotations.Expose;
import iskallia.vault.util.nbt.INBTSerializable;
import iskallia.vault.util.nbt.NBTSerialize;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class Product
implements INBTSerializable {
    protected Item itemCache;
    protected CompoundTag nbtCache;
    @Expose
    @NBTSerialize
    protected String id;
    @Expose
    @NBTSerialize
    protected String nbt;
    @Expose
    @NBTSerialize
    protected int amount;

    public Product() {
    }

    public Product(Item item, int amount, CompoundTag nbt) {
        this.itemCache = item;
        if (this.itemCache != null) {
            this.id = item.getRegistryName().toString();
        }
        this.nbtCache = nbt;
        if (this.nbtCache != null) {
            this.nbt = this.nbtCache.toString();
        }
        this.amount = amount;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Product product = (Product)obj;
        boolean similarNBT = this.getNBT() != null && product.getNBT() != null ? this.getNBT().equals((Object)product.getNBT()) : true;
        return product.getItem() == this.getItem() && similarNBT;
    }

    public int getAmount() {
        return this.amount;
    }

    public Item getItem() {
        if (this.itemCache != null) {
            return this.itemCache;
        }
        this.itemCache = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.id));
        if (this.itemCache == null) {
            System.out.println("Unknown item " + this.id + ".");
        }
        return this.itemCache;
    }

    public String getId() {
        return this.id;
    }

    public CompoundTag getNBT() {
        if (this.nbt == null) {
            return null;
        }
        try {
            if (this.nbtCache == null) {
                this.nbtCache = TagParser.m_129359_((String)this.nbt);
            }
        }
        catch (Exception e) {
            this.nbtCache = null;
            System.out.println("Unknown NBT for item " + this.id + ".");
        }
        return this.nbtCache;
    }

    public boolean isValid() {
        if (this.getAmount() <= 0) {
            return false;
        }
        if (this.getItem() == null) {
            return false;
        }
        if (this.getItem() == Items.f_41852_) {
            return false;
        }
        if (this.getAmount() > this.getItem().m_41459_()) {
            return false;
        }
        return this.nbt == null || this.getNBT() != null;
    }

    public ItemStack toStack() {
        ItemStack stack = new ItemStack((ItemLike)this.getItem(), this.getAmount());
        stack.m_41751_(this.getNBT());
        return stack;
    }

    public String toString() {
        return "{ id='" + this.id + "', nbt='" + this.nbt + "', amount=" + this.amount + "}";
    }
}

