/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public enum VaultCrystalMode implements StringRepresentable
{
    INFINITY("infinity", 0.0f, 0),
    NORMAL("normal", 1.0f, 1),
    GRINDY("grindy", 3.0f, 1),
    EXTREME("extreme", 10.0f, 1);

    private final String name;
    private final float multiplier;
    private final int minCost;
    private static final Map<String, VaultCrystalMode> NAME_VALUES;

    private VaultCrystalMode(String name, float multiplier, int minCost) {
        this.name = name;
        this.multiplier = multiplier;
        this.minCost = minCost;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public int getMinCost() {
        return this.minCost;
    }

    public String m_7912_() {
        return this.name;
    }

    public static VaultCrystalMode fromName(String name) {
        return NAME_VALUES.getOrDefault(name, NORMAL);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (VaultCrystalMode value : VaultCrystalMode.values()) {
            builder.put((Object)value.m_7912_(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }

    public static class GameRuleValue
    extends GameRules.Value<GameRuleValue> {
        private VaultCrystalMode mode = NORMAL;

        public GameRuleValue(GameRules.Type<GameRuleValue> type) {
            super(type);
        }

        public GameRuleValue(GameRules.Type<GameRuleValue> type, VaultCrystalMode mode) {
            super(type);
            this.mode = mode;
        }

        public static GameRules.Type<GameRuleValue> create(VaultCrystalMode defaultValue) {
            return new GameRules.Type(() -> EnumArgument.enumArgument(VaultCrystalMode.class), type -> new GameRuleValue((GameRules.Type<GameRuleValue>)type, defaultValue), (s, v) -> {}, (v, k, t) -> {});
        }

        protected void m_5528_(CommandContext<CommandSourceStack> context, String paramName) {
            this.mode = (VaultCrystalMode)((Object)context.getArgument(paramName, VaultCrystalMode.class));
        }

        protected void m_7377_(String value) {
            this.mode = VaultCrystalMode.fromName(value);
        }

        public String m_5831_() {
            return this.mode.m_7912_();
        }

        public int m_6855_() {
            return this.mode.m_7912_().hashCode();
        }

        protected GameRuleValue getSelf() {
            return this;
        }

        protected GameRuleValue copy() {
            return new GameRuleValue((GameRules.Type<GameRuleValue>)this.f_46360_, this.mode);
        }

        public void setFrom(GameRuleValue value, @Nullable MinecraftServer pServer) {
            this.mode = value.mode;
            this.m_46368_(pServer);
        }

        public VaultCrystalMode get() {
            return this.mode;
        }
    }
}

