/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public enum VaultLoot implements StringRepresentable
{
    LEGACY("legacy", 0.5f),
    NORMAL("normal", 1.0f),
    PLENTY("plenty", 2.0f),
    EXTREME("extreme", 3.0f);

    private final String name;
    private final float multiplier;
    private static final Map<String, VaultLoot> NAME_VALUES;

    private VaultLoot(String name, float multiplier) {
        this.name = name;
        this.multiplier = multiplier;
    }

    public String m_7912_() {
        return this.name;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public static VaultLoot fromName(String name) {
        return NAME_VALUES.getOrDefault(name, NORMAL);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (VaultLoot value : VaultLoot.values()) {
            builder.put((Object)value.m_7912_(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }

    public static class GameRuleValue
    extends GameRules.Value<GameRuleValue> {
        private VaultLoot mode = NORMAL;

        public GameRuleValue(GameRules.Type<GameRuleValue> type) {
            super(type);
        }

        public GameRuleValue(GameRules.Type<GameRuleValue> type, VaultLoot mode) {
            super(type);
            this.mode = mode;
        }

        public static GameRules.Type<GameRuleValue> create(VaultLoot defaultValue) {
            return new GameRules.Type(() -> EnumArgument.enumArgument(VaultLoot.class), type -> new GameRuleValue((GameRules.Type<GameRuleValue>)type, defaultValue), (s, v) -> {}, (v, k, t) -> {});
        }

        protected void m_5528_(CommandContext<CommandSourceStack> context, String paramName) {
            this.mode = (VaultLoot)((Object)context.getArgument(paramName, VaultLoot.class));
        }

        protected void m_7377_(String value) {
            this.mode = VaultLoot.fromName(value);
        }

        public String m_5831_() {
            return this.mode.m_7912_();
        }

        public int m_6855_() {
            return this.mode.m_7912_().hashCode();
        }

        protected GameRuleValue getSelf() {
            return this;
        }

        protected GameRuleValue copy() {
            return new GameRuleValue((GameRules.Type<GameRuleValue>)this.f_46360_, this.mode);
        }

        public void setFrom(GameRuleValue value, @Nullable MinecraftServer pServer) {
            this.mode = value.mode;
            this.m_46368_(pServer);
        }

        public VaultLoot get() {
            return this.mode;
        }
    }
}

