/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.ItemDiscoveryTask;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.config.bounty.task.TaskConfig;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.event.event.BountyCompleteEvent;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundBountyAvailableMessage;
import iskallia.vault.network.message.bounty.ClientboundBountyProgressMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.BountyHunterExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BountyData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_Bounties";
    private final HashMap<UUID, BountyList> active = new HashMap();
    private final HashMap<UUID, BountyList> available = new HashMap();
    private final HashMap<UUID, BountyList> complete = new HashMap();
    private final HashMap<UUID, BountyList> legendary = new HashMap();

    public BountyData() {
        CommonEvents.ENTITY_DROPS.register((Object)this, ItemDiscoveryTask::onLootGeneration, -1);
        CommonEvents.CHEST_LOOT_GENERATION.post().register((Object)this, ItemDiscoveryTask::onLootGeneration, -1);
        CommonEvents.COIN_STACK_LOOT_GENERATION.post().register((Object)this, ItemDiscoveryTask::onLootGeneration, -1);
        CommonEvents.LOOTABLE_BLOCK_GENERATION_EVENT.post().register((Object)this, ItemDiscoveryTask::onLootGeneration, -1);
    }

    private Optional<Bounty> getActiveFor(UUID playerId, UUID bountyId) {
        if (!this.active.containsKey(playerId)) {
            return Optional.empty();
        }
        return this.active.get(playerId).findById(bountyId);
    }

    public BountyList getAllAvailableFor(UUID playerId) {
        if (this.available.containsKey(playerId)) {
            return this.available.get(playerId);
        }
        BountyList list = this.available.computeIfAbsent(playerId, id -> new BountyList());
        this.m_77762_();
        this.syncToClient(playerId);
        return list;
    }

    public BountyList getAllActiveFor(UUID playerId) {
        if (this.active.containsKey(playerId)) {
            return this.active.get(playerId);
        }
        BountyList list = this.active.computeIfAbsent(playerId, id -> new BountyList());
        this.m_77762_();
        this.syncToClient(playerId);
        return list;
    }

    public BountyList getAllCompletedFor(UUID playerId) {
        if (this.complete.containsKey(playerId)) {
            return this.complete.get(playerId);
        }
        BountyList list = this.complete.computeIfAbsent(playerId, id -> new BountyList());
        this.m_77762_();
        this.syncToClient(playerId);
        return list;
    }

    private Optional<Bounty> getLegendaryFor(UUID playerId, UUID bountyId) {
        if (!this.legendary.containsKey(playerId)) {
            return Optional.empty();
        }
        return this.legendary.get(playerId).findById(bountyId);
    }

    public BountyList getAllLegendaryFor(UUID playerId) {
        if (this.legendary.containsKey(playerId)) {
            return this.legendary.get(playerId);
        }
        BountyList list = this.legendary.computeIfAbsent(playerId, id -> new BountyList());
        this.m_77762_();
        this.syncToClient(playerId);
        return list;
    }

    public BountyList getAllBountiesFor(UUID playerId) {
        BountyList list = new BountyList();
        list.addAll(this.active.computeIfAbsent(playerId, id -> new BountyList()));
        list.addAll(this.available.computeIfAbsent(playerId, id -> new BountyList()));
        list.addAll(this.complete.computeIfAbsent(playerId, id -> new BountyList()));
        list.addAll(this.legendary.computeIfAbsent(playerId, id -> new BountyList()));
        return list;
    }

    public CompoundTag getAllBountiesAsTagFor(UUID playerId) {
        CompoundTag bounties = new CompoundTag();
        bounties.m_128365_("active", (Tag)this.getAllActiveFor(playerId).serializeNBT());
        bounties.m_128365_("available", (Tag)this.getAllAvailableFor(playerId).serializeNBT());
        bounties.m_128365_("abandoned", (Tag)this.getAllCompletedFor(playerId).serializeNBT());
        bounties.m_128365_("legendary", (Tag)this.getAllLegendaryFor(playerId).serializeNBT());
        return bounties;
    }

    public <T extends Task<?>> List<T> getAllActiveById(ServerPlayer player, ResourceLocation taskId) {
        return this.active.values().stream().flatMap(Collection::stream).filter(bounty -> bounty.getPlayerId().equals(player.m_142081_())).map(Bounty::getTask).filter(task -> task.getTaskType().equals((Object)taskId)).toList();
    }

    public <T extends Task<?>> List<T> getAllLegendaryById(ServerPlayer player, ResourceLocation taskId) {
        return this.legendary.values().stream().flatMap(Collection::stream).filter(bounty -> bounty.getPlayerId().equals(player.m_142081_())).map(Bounty::getTask).filter(task -> task.getTaskType().equals((Object)taskId)).toList();
    }

    public void resetAvailableBountiesFor(UUID playerId) {
        this.available.remove(playerId);
        int totalBounties = 3;
        int amountToGenerate = totalBounties - this.getAllActiveFor(playerId).size() - this.getAllCompletedFor(playerId).size();
        this.available.put(playerId, this.generate(playerId, amountToGenerate));
        this.m_77762_();
        this.syncToClient(playerId);
    }

    private Bounty generateBounty(UUID playerId) {
        int vaultLevel = PlayerVaultStatsData.get(ServerLifecycleHooks.getCurrentServer()).getVaultStats(playerId).getVaultLevel();
        ResourceLocation taskId = ModConfigs.BOUNTY_CONFIG.getRandomTask();
        Object config = TaskConfig.getConfig(taskId);
        Object properties = ((TaskConfig)config).getGeneratedTaskProperties(vaultLevel);
        TaskReward reward = ModConfigs.REWARD_CONFIG.generateReward(vaultLevel, ((TaskProperties)properties).getRewardPool());
        UUID bountyId = UUID.randomUUID();
        return new Bounty(bountyId, playerId, (Task<?>)TaskRegistry.createTask(taskId, bountyId, properties, reward));
    }

    private Bounty generateLegendaryBounty(UUID playerId) {
        int vaultLevel = PlayerVaultStatsData.get(ServerLifecycleHooks.getCurrentServer()).getVaultStats(playerId).getVaultLevel();
        ResourceLocation taskId = ModConfigs.BOUNTY_CONFIG.getRandomTask();
        Object config = TaskConfig.getConfig(taskId);
        Object properties = ((TaskConfig)config).getGeneratedTaskProperties(vaultLevel);
        ((TaskProperties)properties).setRewardPool("legendary");
        TaskReward reward = ModConfigs.REWARD_CONFIG.generateReward(vaultLevel, ((TaskProperties)properties).getRewardPool());
        UUID bountyId = UUID.randomUUID();
        return new Bounty(bountyId, playerId, (Task<?>)TaskRegistry.createTask(taskId, bountyId, properties, reward));
    }

    private BountyList generate(UUID playerId, int amount) {
        BountyList list = new BountyList();
        for (int i = 0; i < amount; ++i) {
            list.add(this.generateBounty(playerId));
        }
        return list;
    }

    public void setActive(ServerPlayer player, UUID bountyId) {
        BountyList active = this.getAllActiveFor(player.m_142081_());
        ExpertiseTree expertises = PlayerExpertisesData.get(player.m_183503_()).getExpertises((Player)player);
        int maxActive = 0;
        for (BountyHunterExpertise expertise : expertises.getAll(BountyHunterExpertise.class, Skill::isUnlocked)) {
            maxActive += expertise.getMaxActive();
        }
        if (maxActive == 0) {
            maxActive = 1;
        }
        if (active.size() >= maxActive) {
            return;
        }
        BountyList available = this.getAllAvailableFor(player.m_142081_());
        Optional<Bounty> bountyOptional = available.findById(bountyId);
        if (bountyOptional.isEmpty()) {
            return;
        }
        if (available.removeById(bountyId)) {
            active.add(bountyOptional.get());
            this.m_77762_();
            this.syncToClient(player.m_142081_());
        }
    }

    public void abandon(ServerPlayer player, UUID bountyId) {
        UUID playerId = player.m_142081_();
        Optional<Bounty> legendaryBounty = this.getLegendaryFor(playerId, bountyId);
        if (legendaryBounty.isPresent()) {
            this.getAllLegendaryFor(playerId).removeById(bountyId);
            this.m_77762_();
            this.syncToClient(playerId);
            return;
        }
        Optional<Bounty> activeBounty = this.getActiveFor(playerId, bountyId);
        if (activeBounty.isEmpty()) {
            return;
        }
        ExpertiseTree expertises = PlayerExpertisesData.get(player.m_183503_()).getExpertises((Player)player);
        float abandonedPenaltyReduction = 0.0f;
        for (BountyHunterExpertise expertise : expertises.getAll(BountyHunterExpertise.class, Skill::isUnlocked)) {
            abandonedPenaltyReduction += expertise.getAbandonedPenaltyReduction();
        }
        Bounty active = activeBounty.get();
        active.setExpiration(Instant.now().plus((long)((float)ModConfigs.BOUNTY_CONFIG.getAbandonedPenaltySeconds() * (1.0f - abandonedPenaltyReduction)), ChronoUnit.SECONDS).toEpochMilli());
        this.getAllActiveFor(playerId).removeById(bountyId);
        this.getAllCompletedFor(playerId).add(active);
        this.m_77762_();
        this.syncToClient(playerId);
    }

    public void complete(ServerPlayer player, UUID bountyId) {
        UUID playerId = player.m_142081_();
        Optional<Bounty> legendaryBounty = this.getLegendaryFor(playerId, bountyId);
        if (legendaryBounty.isPresent()) {
            this.getAllLegendaryFor(playerId).removeById(bountyId);
            legendaryBounty.get().getTask().getTaskReward().apply(player);
            this.m_77762_();
            this.syncToClient(playerId);
            MinecraftForge.EVENT_BUS.post((Event)new BountyCompleteEvent((Player)player, legendaryBounty.get().getTask()));
            return;
        }
        Optional<Bounty> activeBounty = this.getActiveFor(playerId, bountyId);
        if (activeBounty.isEmpty()) {
            return;
        }
        ExpertiseTree expertises = PlayerExpertisesData.get(player.m_183503_()).getExpertises((Player)player);
        int waitingPeriodReduction = 0;
        for (BountyHunterExpertise expertise : expertises.getAll(BountyHunterExpertise.class, Skill::isUnlocked)) {
            waitingPeriodReduction += expertise.getWaitingPeriodReduction();
        }
        Bounty active = activeBounty.get();
        active.setExpiration(Instant.now().plus(Math.max(ModConfigs.BOUNTY_CONFIG.getWaitingPeriodSeconds() - (long)waitingPeriodReduction, 0L), ChronoUnit.SECONDS).toEpochMilli());
        this.getAllActiveFor(playerId).removeById(bountyId);
        this.getAllCompletedFor(playerId).add(active);
        active.getTask().getTaskReward().apply(player);
        this.m_77762_();
        this.syncToClient(playerId);
        MinecraftForge.EVENT_BUS.post((Event)new BountyCompleteEvent((Player)player, active.getTask()));
    }

    public void reroll(ServerPlayer player, UUID bountyId) {
        UUID playerId = player.m_142081_();
        this.getAllActiveFor(playerId).removeById(bountyId);
        this.getAllAvailableFor(playerId).removeById(bountyId);
        this.getAllCompletedFor(playerId).removeById(bountyId);
        this.getAllAvailableFor(playerId).add(this.generateBounty(playerId));
        this.m_77762_();
        this.syncToClient(playerId);
    }

    public void setupLegendary(UUID playerId) {
        if (this.legendary.containsKey(playerId) && !this.legendary.get(playerId).isEmpty()) {
            return;
        }
        BountyList list = new BountyList(List.of(this.generateLegendaryBounty(playerId)));
        this.legendary.put(playerId, list);
        this.m_77762_();
        this.syncToClient(playerId);
    }

    private boolean playerExists(UUID uuid) {
        return this.active.containsKey(uuid) || this.available.containsKey(uuid) || this.complete.containsKey(uuid);
    }

    private void clearAll() {
        this.available.clear();
        this.active.clear();
        this.complete.clear();
        this.legendary.clear();
    }

    public static BountyData create(CompoundTag nbt) {
        BountyData data = new BountyData();
        data.load(nbt);
        return data;
    }

    private void load(CompoundTag tag) {
        this.clearAll();
        CompoundTag availableTag = tag.m_128469_("available");
        availableTag.m_128431_().forEach(idString -> {
            UUID playerId = UUID.fromString(idString);
            List<Bounty> list = NBTHelper.readList(availableTag, idString, CompoundTag.class, Bounty::new);
            this.available.put(playerId, new BountyList(list));
        });
        CompoundTag activeTag = tag.m_128469_("active");
        activeTag.m_128431_().forEach(idString -> {
            UUID playerId = UUID.fromString(idString);
            List<Bounty> list = NBTHelper.readList(activeTag, idString, CompoundTag.class, Bounty::new);
            this.active.put(playerId, new BountyList(list));
        });
        CompoundTag completeTag = tag.m_128469_("complete");
        completeTag.m_128431_().forEach(idString -> {
            UUID playerId = UUID.fromString(idString);
            List<Bounty> list = NBTHelper.readList(completeTag, idString, CompoundTag.class, Bounty::new);
            this.complete.put(playerId, new BountyList(list));
        });
        CompoundTag legendaryTag = tag.m_128469_("legendary");
        legendaryTag.m_128431_().forEach(idString -> {
            UUID playerId = UUID.fromString(idString);
            List<Bounty> list = NBTHelper.readList(legendaryTag, idString, CompoundTag.class, Bounty::new);
            this.legendary.put(playerId, new BountyList(list));
        });
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag availableTag = new CompoundTag();
        CompoundTag activeTag = new CompoundTag();
        CompoundTag completeTag = new CompoundTag();
        CompoundTag legendaryTag = new CompoundTag();
        this.available.forEach((playerId, bountyList) -> NBTHelper.writeCollection(availableTag, playerId.toString(), bountyList, CompoundTag.class, Bounty::serializeNBT));
        this.active.forEach((playerId, bountyList) -> NBTHelper.writeCollection(activeTag, playerId.toString(), bountyList, CompoundTag.class, Bounty::serializeNBT));
        this.complete.forEach((playerId, bountyList) -> NBTHelper.writeCollection(completeTag, playerId.toString(), bountyList, CompoundTag.class, Bounty::serializeNBT));
        this.legendary.forEach((playerId, bountyList) -> NBTHelper.writeCollection(legendaryTag, playerId.toString(), bountyList, CompoundTag.class, Bounty::serializeNBT));
        nbt.m_128365_("available", (Tag)availableTag);
        nbt.m_128365_("active", (Tag)activeTag);
        nbt.m_128365_("complete", (Tag)completeTag);
        nbt.m_128365_("legendary", (Tag)legendaryTag);
        return nbt;
    }

    private void syncToClient(UUID playerId) {
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerId);
        if (serverPlayer == null) {
            return;
        }
        BountyList legendary = BountyData.get().getAllLegendaryFor(serverPlayer.m_142081_());
        BountyList active = BountyData.get().getAllActiveFor(serverPlayer.m_142081_());
        BountyList available = BountyData.get().getAllAvailableFor(serverPlayer.m_142081_());
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        bounties.addAll(legendary);
        bounties.addAll(active);
        ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyProgressMessage(bounties), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyAvailableMessage(available), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (BountyData.get().playerExists(event.getPlayer().m_142081_())) {
            BountyData.syncBounties(serverPlayer);
            return;
        }
        BountyData.get().resetAvailableBountiesFor(event.getPlayer().m_142081_());
    }

    public static void syncBounties(ServerPlayer serverPlayer) {
        BountyList legendaryList;
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        BountyList activeList = BountyData.get().getAllActiveFor(serverPlayer.m_142081_());
        if (!activeList.isEmpty()) {
            bounties.addAll(activeList);
        }
        if (!(legendaryList = BountyData.get().getAllLegendaryFor(serverPlayer.m_142081_())).isEmpty()) {
            bounties.addAll(legendaryList);
        }
        if (!bounties.isEmpty()) {
            ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyProgressMessage(bounties), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        } else {
            ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyProgressMessage(null), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyAvailableMessage(BountyData.get().getAllAvailableFor(serverPlayer.m_142081_())), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        BountyData.get().tick();
    }

    public void tick() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_129783_().m_46467_() % 20L == 0L) {
            this.checkAbandonedExpiration();
        }
    }

    private void checkAbandonedExpiration() {
        if (this.complete.isEmpty()) {
            return;
        }
        List<Bounty> expired = this.complete.values().stream().flatMap(Collection::stream).filter(Bounty::isExpired).toList();
        for (Bounty bounty : expired) {
            UUID bountyId = bounty.getId();
            UUID playerId = bounty.getPlayerId();
            BountyList completedBounties = this.complete.get(playerId);
            if (!completedBounties.removeById(bountyId)) continue;
            this.getAllAvailableFor(playerId).add(this.generateBounty(playerId));
            this.m_77762_();
            this.syncToClient(playerId);
        }
    }

    public void resetAllBounties(UUID uuid) {
        this.active.computeIfAbsent(uuid, id -> new BountyList()).clear();
        this.available.computeIfAbsent(uuid, id -> new BountyList()).clear();
        this.complete.computeIfAbsent(uuid, id -> new BountyList()).clear();
        this.resetAvailableBountiesFor(uuid);
        this.m_77762_();
        this.syncToClient(uuid);
    }

    public static BountyData get() {
        return (BountyData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(BountyData::create, BountyData::new, DATA_NAME);
    }
}

