/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.DiscoveredAlchemyEffectsMessage;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;

public class DiscoveredAlchemyEffectsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveredAlchemyModifiers";
    protected Map<UUID, Set<String>> discoveredEffects = new HashMap<UUID, Set<String>>();

    private DiscoveredAlchemyEffectsData() {
    }

    private DiscoveredAlchemyEffectsData(CompoundTag tag) {
        this.load(tag);
    }

    public boolean compoundDiscoverEffect(ServerPlayer player, String effectId) {
        return this.discoverAlchemyEffect(player, effectId);
    }

    private boolean discoverAlchemyEffect(ServerPlayer player, String effectId) {
        Set craftKeys = this.discoveredEffects.computeIfAbsent(player.m_142081_(), id -> new HashSet());
        if (craftKeys.add(effectId)) {
            this.m_77762_();
            this.syncTo(player);
            return true;
        }
        return false;
    }

    public boolean hasDiscoveredEffect(Player player, String effectId) {
        return this.discoveredEffects.getOrDefault(player.m_142081_(), Collections.emptySet()).contains(effectId);
    }

    private DiscoveredAlchemyEffectsMessage getUpdatePacket(UUID playerId) {
        return new DiscoveredAlchemyEffectsMessage(this.discoveredEffects.getOrDefault(playerId, Collections.emptySet()));
    }

    public void syncTo(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)this.getUpdatePacket(player.m_142081_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag discoveredEffectTag = new ListTag();
        this.discoveredEffects.forEach((playerId, itemCrafts) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", playerId);
            NBTHelper.writeCollection(playerTag, "effects", itemCrafts, StringTag.class, StringTag::m_129297_);
            discoveredEffectTag.add((Object)playerTag);
        });
        tag.m_128365_("discoveredEffects", (Tag)discoveredEffectTag);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.discoveredEffects.clear();
        ListTag playerTrinkets = tag.m_128437_("discoveredEffects", 10);
        for (int i = 0; i < playerTrinkets.size(); ++i) {
            CompoundTag playerTag = playerTrinkets.m_128728_(i);
            UUID playerId = playerTag.m_128342_("player");
            Set<String> effects = NBTHelper.readSet(playerTag, "effects", StringTag.class, StringTag::m_7916_);
            this.discoveredEffects.put(playerId, effects);
        }
    }

    public static DiscoveredAlchemyEffectsData get(ServerLevel level) {
        return DiscoveredAlchemyEffectsData.get(level.m_142572_());
    }

    public static DiscoveredAlchemyEffectsData get(MinecraftServer server) {
        return (DiscoveredAlchemyEffectsData)server.m_129783_().m_8895_().m_164861_(DiscoveredAlchemyEffectsData::new, DiscoveredAlchemyEffectsData::new, DATA_NAME);
    }
}

