/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.EternalSyncMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EternalsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_Eternals";
    private final Map<UUID, EternalGroup> playerMap = new HashMap<UUID, EternalGroup>();

    public int getTotalEternals() {
        int total = 0;
        for (EternalGroup group : this.playerMap.values()) {
            total = (int)((long)total + group.getEternals().stream().filter(eternal -> !eternal.isAncient()).count());
        }
        return total;
    }

    @Nonnull
    public EternalGroup getEternals(Player player) {
        return this.getEternals(player.m_142081_());
    }

    @Nonnull
    public EternalGroup getEternals(UUID player) {
        return this.playerMap.computeIfAbsent(player, uuid -> new EternalGroup());
    }

    public List<String> getAllEternalNamesExcept(@Nullable String current) {
        HashSet<String> names = new HashSet<String>();
        for (UUID id : this.playerMap.keySet()) {
            EternalGroup group = this.playerMap.get(id);
            for (EternalData data : group.getEternals()) {
                names.add(data.getName());
            }
        }
        if (current != null && !current.isEmpty()) {
            names.remove(current);
        }
        return new ArrayList<String>(names);
    }

    public UUID add(UUID owner, String name, boolean isAncient, EternalVariant variant, boolean isUsingPlayerSkin) {
        UUID eternalId = this.getEternals(owner).addEternal(name, isAncient, variant, isUsingPlayerSkin);
        this.m_77762_();
        return eternalId;
    }

    @Nullable
    public UUID getOwnerOf(UUID eternalId) {
        return this.playerMap.entrySet().stream().filter(e -> ((EternalGroup)e.getValue()).containsEternal(eternalId)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    @Nullable
    public EternalData getEternal(UUID eternalId) {
        for (EternalGroup eternalGroup : this.playerMap.values()) {
            EternalData eternal = eternalGroup.get(eternalId);
            if (eternal == null) continue;
            return eternal;
        }
        return null;
    }

    public boolean removeEternal(UUID eternalId) {
        for (EternalGroup eternalGroup : this.playerMap.values()) {
            if (!eternalGroup.removeEternal(eternalId)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public EternalData.EquipmentInventory getEternalEquipmentInventory(UUID eternalId, Runnable onChange) {
        EternalData eternal = this.getEternal(eternalId);
        if (eternal == null) {
            return null;
        }
        return eternal.getEquipmentInventory(onChange);
    }

    public Map<UUID, List<EternalDataSnapshot>> getEternalDataSnapshots() {
        HashMap<UUID, List<EternalDataSnapshot>> eternalDataSet = new HashMap<UUID, List<EternalDataSnapshot>>();
        this.playerMap.forEach((playerUUID, eternalGrp) -> eternalDataSet.put((UUID)playerUUID, eternalGrp.getEternalSnapshots()));
        return eternalDataSet;
    }

    public void syncTo(ServerPlayer sPlayer) {
        EternalSyncMessage pkt = new EternalSyncMessage(this.getEternalDataSnapshots());
        ModNetwork.CHANNEL.sendTo((Object)pkt, sPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void syncAll() {
        EternalSyncMessage pkt = new EternalSyncMessage(this.getEternalDataSnapshots());
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)pkt);
    }

    public void m_77762_() {
        super.m_77762_();
        this.syncAll();
    }

    private static EternalsData create(CompoundTag tag) {
        EternalsData data = new EternalsData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
        ListTag eternalsList = nbt.m_128437_("EternalEntries", 10);
        if (playerList.size() != eternalsList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getEternals(playerUUID).deserializeNBT(eternalsList.m_128728_(i));
        }
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag eternalsList = new ListTag();
        this.playerMap.forEach((uuid, eternalGroup) -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            eternalsList.add((Object)eternalGroup.serializeNBT());
        });
        nbt.m_128365_("PlayerEntries", (Tag)playerList);
        nbt.m_128365_("EternalEntries", (Tag)eternalsList);
        return nbt;
    }

    public static EternalsData get(ServerLevel world) {
        return EternalsData.get(world.m_142572_());
    }

    public static EternalsData get(MinecraftServer srv) {
        return (EternalsData)srv.m_129783_().m_8895_().m_164861_(EternalsData::create, EternalsData::new, DATA_NAME);
    }

    public boolean m_77764_() {
        return true;
    }

    public class EternalGroup
    implements INBTSerializable<CompoundTag> {
        private final Map<UUID, EternalData> eternals = new HashMap<UUID, EternalData>();

        public List<EternalData> getEternals() {
            return new ArrayList<EternalData>(this.eternals.values());
        }

        public int getNonAncientEternalCount() {
            return (int)this.eternals.entrySet().stream().filter(entry -> !((EternalData)entry.getValue()).isAncient()).count();
        }

        public UUID addEternal(String name, boolean isAncient, EternalVariant variant, boolean isUsingPlayerSkin) {
            return this.addEternal(EternalData.createEternal(EternalsData.this, name, isAncient, variant, isUsingPlayerSkin)).getId();
        }

        private EternalData addEternal(EternalData newEternal) {
            this.eternals.put(newEternal.getId(), newEternal);
            this.eternals.values().forEach(eternal -> {
                if (eternal.isAncient()) {
                    eternal.setLevel(eternal.getMaxLevel());
                }
            });
            return newEternal;
        }

        @Nullable
        public EternalData get(UUID eternalId) {
            return this.eternals.get(eternalId);
        }

        public boolean containsEternal(UUID eternalId) {
            return this.get(eternalId) != null;
        }

        public boolean containsEternal(String name) {
            for (EternalData eternal : this.eternals.values()) {
                if (!eternal.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        public boolean containsOriginalEternal(String name, boolean onlyAncients) {
            for (EternalData eternal : this.eternals.values()) {
                if (onlyAncients && !eternal.isAncient() || !eternal.getOriginalName().equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        public boolean removeEternal(UUID eternalId) {
            EternalData eternal = this.eternals.remove(eternalId);
            if (eternal != null) {
                EternalsData.this.m_77762_();
                return true;
            }
            return false;
        }

        @Nullable
        public EternalData getRandomAlive(Random random, Predicate<EternalData> eternalFilter) {
            List aliveEternals = this.getEternals().stream().filter(EternalData::isAlive).filter(eternalFilter).collect(Collectors.toList());
            if (aliveEternals.isEmpty()) {
                return null;
            }
            return (EternalData)aliveEternals.get(random.nextInt(aliveEternals.size()));
        }

        @Nullable
        public EternalData getRandomAliveAncient(Random random, Predicate<EternalData> eternalFilter) {
            List aliveEternals = this.getEternals().stream().filter(EternalData::isAlive).filter(EternalData::isAncient).filter(eternalFilter).collect(Collectors.toList());
            if (aliveEternals.isEmpty()) {
                return null;
            }
            return (EternalData)aliveEternals.get(random.nextInt(aliveEternals.size()));
        }

        public List<EternalDataSnapshot> getEternalSnapshots() {
            ArrayList<EternalDataSnapshot> snapshots = new ArrayList<EternalDataSnapshot>();
            this.getEternals().forEach(eternal -> snapshots.add(this.getEternalSnapshot((EternalData)eternal)));
            return snapshots;
        }

        @Nullable
        public EternalDataSnapshot getEternalSnapshot(UUID eternalId) {
            EternalData eternal = this.get(eternalId);
            if (eternal == null) {
                return null;
            }
            return this.getEternalSnapshot(eternal);
        }

        public EternalDataSnapshot getEternalSnapshot(EternalData eternal) {
            return EternalDataSnapshot.getFromEternal(this, eternal);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ListTag eternalsList = new ListTag();
            this.eternals.values().forEach(eternal -> eternalsList.add((Object)eternal.serializeNBT()));
            nbt.m_128365_("EternalsList", (Tag)eternalsList);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.eternals.clear();
            ListTag eternalsList = nbt.m_128437_("EternalsList", 10);
            for (int i = 0; i < eternalsList.size(); ++i) {
                this.addEternal(EternalData.fromNBT(EternalsData.this, eternalsList.m_128728_(i)));
            }
        }
    }

    public static enum EternalVariant {
        CAVE(0),
        DESERT(1),
        HELL(2),
        ICE(3),
        LUSH(4),
        VOID(5);

        private static final EternalVariant[] BY_ID;
        private final int id;

        private EternalVariant(int pId) {
            this.id = pId;
        }

        public int getId() {
            return this.id;
        }

        public static EternalVariant byId(int pId) {
            return BY_ID[pId % BY_ID.length];
        }

        static {
            BY_ID = (EternalVariant[])Arrays.stream(EternalVariant.values()).sorted(Comparator.comparingInt(EternalVariant::getId)).toArray(EternalVariant[]::new);
        }
    }
}

