/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.crystal.data.serializable.INbtSerializable;
import iskallia.vault.network.message.UpdateGodAltarDataMessage;
import iskallia.vault.task.Task;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class GodAltarData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_GodAltars";
    public static List<Entry> CLIENT = new ArrayList<Entry>();
    private final Map<UUID, Entry> entries = new HashMap<UUID, Entry>();

    public static Optional<Entry> get(UUID uuid) {
        return Optional.ofNullable(GodAltarData.get().entries.get(uuid));
    }

    public static UUID add(UUID uuid, Task task, TaskSource source, VaultGod god) {
        GodAltarData data = GodAltarData.get();
        data.entries.put(uuid, new Entry(task, source, god));
        task.onStart(source);
        return uuid;
    }

    public static void remove(UUID uuid) {
        GodAltarData data = GodAltarData.get();
        Entry entry = data.entries.remove(uuid);
        if (entry != null) {
            entry.task.onDetach();
        }
    }

    public static boolean contains(Entity entity) {
        for (Entry entry : GodAltarData.get().entries.values()) {
            EntityTaskSource entitySource;
            TaskSource taskSource = entry.source;
            if (!(taskSource instanceof EntityTaskSource) || !(entitySource = (EntityTaskSource)taskSource).matches(entity)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        GodAltarData.get().entries.forEach((id, entry) -> entry.task.onAttach(entry.source));
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        new ArrayList<Entry>(GodAltarData.get().entries.values()).forEach(entry -> entry.task.onTick(entry.source));
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        GodAltarData.get().entries.forEach((id, entry) -> entry.task.onDetach());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ArrayList<Entry> tasks = new ArrayList<Entry>();
            for (Entry value : GodAltarData.get().entries.values()) {
                EntityTaskSource entitySource;
                TaskSource taskSource = value.source;
                if (!(taskSource instanceof EntityTaskSource) || !(entitySource = (EntityTaskSource)taskSource).matches((Entity)player2)) continue;
                tasks.add(value);
            }
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new UpdateGodAltarDataMessage(tasks));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            ArrayList<Entry> tasks = new ArrayList<Entry>();
            for (Entry value : GodAltarData.get().entries.values()) {
                EntityTaskSource entitySource;
                TaskSource taskSource = value.source;
                if (!(taskSource instanceof EntityTaskSource) || !(entitySource = (EntityTaskSource)taskSource).matches((Entity)player)) continue;
                tasks.add(value);
            }
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new UpdateGodAltarDataMessage(tasks));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new UpdateGodAltarDataMessage(new ArrayList<Entry>()));
        }
    }

    public static boolean contains(UUID uuid) {
        return GodAltarData.get().entries.containsKey(uuid);
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag nbt) {
        this.entries.forEach((uuid, entry) -> entry.writeNbt().ifPresent(entryNbt -> nbt.m_128365_(uuid.toString(), (Tag)entryNbt)));
        return nbt;
    }

    private static GodAltarData load(CompoundTag nbt) {
        GodAltarData data = new GodAltarData();
        nbt.m_128431_().forEach(key -> {
            Entry entry = new Entry();
            entry.readNbt(nbt.m_128469_(key));
            data.entries.put(UUID.fromString(key), entry);
        });
        return data;
    }

    public boolean m_77764_() {
        return true;
    }

    public static GodAltarData get() {
        return (GodAltarData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(GodAltarData::load, GodAltarData::new, DATA_NAME);
    }

    public static class Entry
    implements INbtSerializable<CompoundTag> {
        private Task task;
        private TaskSource source;
        private VaultGod god;

        public Entry() {
        }

        public Entry(Task task, TaskSource source, VaultGod god) {
            this.task = task;
            this.source = source;
            this.god = god;
        }

        public Task getTask() {
            return this.task;
        }

        public TaskSource getSource() {
            return this.source;
        }

        public VaultGod getGod() {
            return this.god;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.TASK.writeNbt(this.task).ifPresent(task -> nbt.m_128365_("task", task));
            Adapters.TASK_SOURCE.writeNbt(this.source).ifPresent(source -> nbt.m_128365_("source", source));
            Adapters.GOD_ORDINAL.writeNbt(this.god).ifPresent(god -> nbt.m_128365_("god", god));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.task = Adapters.TASK.readNbt(nbt.m_128423_("task")).orElse(null);
            this.source = Adapters.TASK_SOURCE.readNbt(nbt.m_128423_("source")).orElse(null);
            this.god = Adapters.GOD_ORDINAL.readNbt(nbt.m_128423_("god")).orElse(null);
        }
    }
}

