/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.world.data.InventorySnapshot;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public abstract class InventorySnapshotData
extends SavedData {
    public VMapNBT<UUID, InventorySnapshot> snapshotData = VMapNBT.ofUUID(InventorySnapshot::new);

    protected abstract boolean shouldSnapshotItem(Player var1, ItemStack var2);

    protected InventorySnapshot.Builder makeSnapshotBuilder(Player player) {
        return new InventorySnapshot.Builder(player).setStackFilter(this::shouldSnapshotItem).removeSnapshotItems();
    }

    public boolean hasSnapshot(Player player) {
        return this.hasSnapshot(player.m_142081_());
    }

    public boolean hasSnapshot(UUID playerUUID) {
        return this.snapshotData.containsKey(playerUUID);
    }

    public void createSnapshot(Player player) {
        if (this.snapshotData.containsKey(player.m_142081_())) {
            this.restoreSnapshot(player);
        }
        this.snapshotData.put(player.m_142081_(), this.makeSnapshotBuilder(player).createSnapshot());
        this.m_77762_();
    }

    public boolean removeSnapshot(Player player) {
        return this.removeSnapshot(player.m_142081_());
    }

    public boolean removeSnapshot(UUID playerUUID) {
        if (this.snapshotData.remove(playerUUID) != null) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean restoreSnapshot(Player player) {
        InventorySnapshot snapshot = this.snapshotData.remove(player.m_142081_());
        if (snapshot != null) {
            this.m_77762_();
            return snapshot.apply(player);
        }
        return false;
    }

    public void load(CompoundTag nbt) {
        this.snapshotData.deserializeNBT(nbt.m_128437_("Players", 10));
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128365_("Players", (Tag)this.snapshotData.serializeNBT());
        return compound;
    }

    public static interface InventoryAccessor {
        public int getSize();
    }
}

