/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.world.data.PlayerTalentsData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.QuestStatesData;
import iskallia.vault.world.data.ScheduledItemDropData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerAbilitiesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerAbilities";
    private final Map<UUID, AbilityTree> playerMap = new HashMap<UUID, AbilityTree>();
    private final Set<UUID> scheduledMerge = new HashSet<UUID>();
    private AbilityTree previous;
    private final Set<UUID> scheduledRefund = new HashSet<UUID>();
    private final Set<UUID> scheduledCorruptionCheck = new HashSet<UUID>();
    private int version = 1;

    public AbilityTree getAbilities(Player player) {
        return this.getAbilities(player.m_142081_());
    }

    public void setAbilities(Player player, AbilityTree abilityTree) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            this.getAbilities((Player)serverPlayer).getAll(LearnableSkill.class, Skill::isUnlocked).forEach(skill -> skill.onRemove(SkillContext.of(serverPlayer)));
        }
        this.playerMap.put(player.m_142081_(), abilityTree);
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            abilityTree.getAll(LearnableSkill.class, Skill::isUnlocked).forEach(skill -> skill.onAdd(SkillContext.of(serverPlayer)));
        }
        this.m_77762_();
    }

    public AbilityTree getAbilities(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, id -> (AbilityTree)ModConfigs.ABILITIES.get().orElse(new AbilityTree()).copy());
    }

    public static void setAbilityOnCooldown(ServerPlayer player, Class<?> type) {
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        abilities.iterate(type, skill -> {
            if (skill instanceof Ability) {
                Ability ability = (Ability)skill;
                ability.putOnCooldown(SkillContext.of(player));
            }
        });
    }

    public static void deactivateAllAbilities(ServerPlayer player) {
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        abilities.iterate(Ability.class, ability -> ability.setActive(false));
    }

    public boolean m_77764_() {
        return true;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer()) {
            PlayerAbilitiesData data = PlayerAbilitiesData.get((ServerLevel)event.world);
            AbilityTree current = ModConfigs.ABILITIES.get().orElse(null);
            if (data.previous != current && current != null) {
                data.previous = current;
                data.scheduledMerge.addAll(data.playerMap.keySet());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer() && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerAbilitiesData data = PlayerAbilitiesData.get(player2.m_183503_());
            if (data.scheduledMerge.remove(player2.m_142081_())) {
                ModConfigs.ABILITIES.get().ifPresent(tree -> {
                    SkillContext context = SkillContext.of(player2);
                    data.playerMap.get(player2.m_142081_()).mergeFrom((Skill)tree.copy(), context);
                    PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats((Player)player2);
                    stats.setSkillPoints(context.getLearnPoints());
                    stats.setRegretPoints(context.getRegretPoints());
                });
            }
            data.getAbilities((Player)player2).onTick(SkillContext.of(player2));
            if (data.scheduledRefund.remove(player2.m_142081_())) {
                PlayerVaultStats stats = PlayerVaultStatsData.get(player2.m_183503_()).getVaultStats((Player)player2);
                int skillOrbs = stats.getTotalSpentSkillPoints() + stats.getUnspentSkillPoints() - stats.getVaultLevel();
                stats.setSkillPoints(stats.getVaultLevel());
                stats.setTotalSpentSkillPoints(0);
                stats.setExpertisePoints(stats.getVaultLevel() / 5);
                stats.setTotalSpentExpertisePoints(0);
                ScheduledItemDropData drops = ScheduledItemDropData.get(player2.m_183503_());
                drops.addDrop((Player)player2, new ItemStack((ItemLike)ModItems.EXTRAORDINARY_BENITOITE, skillOrbs));
                drops.addDrop((Player)player2, new ItemStack((ItemLike)ModItems.BLACK_OPAL_GEM, skillOrbs * 4));
                drops.addDrop((Player)player2, new ItemStack((ItemLike)ModItems.VAULT_ESSENCE, skillOrbs * 4));
            }
            if (data.scheduledCorruptionCheck.remove(player2.m_142081_())) {
                PlayerVaultStats vaultStats = PlayerVaultStatsData.get(player2.m_183503_()).getVaultStats((Player)player2);
                int valid = vaultStats.getVaultLevel();
                if (QuestStatesData.get().getState(player2).getCompleted().contains((Object)"learning_skills")) {
                    ++valid;
                }
                int current = vaultStats.getUnspentSkillPoints() + data.playerMap.get(player2.m_142081_()).getSpentLearnPoints();
                if ((current += PlayerTalentsData.get(player2.m_183503_()).getTalents((Player)player2).getSpentLearnPoints()) != valid) {
                    PlayerVaultStatsData.get(player2.m_183503_()).resetSkills(player2, false);
                    vaultStats.setSkillPoints(valid);
                    PlayerVaultStatsData.get(player2.m_183503_()).m_77762_();
                    MutableComponent message = TextComponent.f_131282_.m_6881_().m_7220_((Component)new TextComponent("Your abilities and talents have been reset due to a data corruption issue. You now have").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(" " + valid + " ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)new TextComponent("skill points available instead of").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(" " + current).m_130940_(ChatFormatting.RED)).m_7220_((Component)new TextComponent(". This amount equals your level with an additional point if you completed the skill quest.").m_130940_(ChatFormatting.GRAY));
                    player2.m_6352_((Component)message, Util.f_137441_);
                    VaultMod.LOGGER.warn("[" + player2.m_5446_().getString() + "] " + message.getString());
                }
            }
        }
    }

    public void load(CompoundTag nbt) {
        int i;
        this.playerMap.clear();
        this.scheduledMerge.clear();
        this.scheduledRefund.clear();
        this.scheduledCorruptionCheck.clear();
        this.version = nbt.m_128451_("Version");
        if (nbt.m_128425_("PlayerEntries", 9)) {
            this.version = -1;
        } else {
            ListTag scheduledRefund = nbt.m_128437_("ScheduledRefund", 8);
            for (i = 0; i < scheduledRefund.size(); ++i) {
                this.scheduledRefund.add(UUID.fromString(scheduledRefund.m_128778_(i)));
            }
        }
        ListTag scheduledCorruptionCheck = nbt.m_128437_("ScheduledCorruptionCheck", 8);
        for (i = 0; i < scheduledCorruptionCheck.size(); ++i) {
            this.scheduledCorruptionCheck.add(UUID.fromString(scheduledCorruptionCheck.m_128778_(i)));
        }
        ListTag playerList = nbt.m_128437_("Players", 8);
        ListTag abilitiesList = nbt.m_128437_("Abilities", 10);
        if (playerList.size() != abilitiesList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i2 = 0; i2 < playerList.size(); ++i2) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i2));
            Adapters.SKILL.readNbt((Tag)abilitiesList.m_128728_(i2)).ifPresent(tree -> {
                this.playerMap.put(playerUUID, (AbilityTree)tree);
                this.scheduledMerge.add(playerUUID);
            });
        }
        this.migrate(nbt);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag abilitiesList = new ListTag();
        ListTag scheduledRefund = new ListTag();
        ListTag scheduledCorruptionCheck = new ListTag();
        this.playerMap.forEach((uuid, researchTree) -> Adapters.SKILL.writeNbt(researchTree).ifPresent(tag -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            abilitiesList.add(tag);
        }));
        this.scheduledRefund.forEach(uuid -> scheduledRefund.add((Object)StringTag.m_129297_((String)uuid.toString())));
        this.scheduledCorruptionCheck.forEach(uuid -> scheduledCorruptionCheck.add((Object)StringTag.m_129297_((String)uuid.toString())));
        nbt.m_128405_("Version", this.version);
        nbt.m_128365_("Players", (Tag)playerList);
        nbt.m_128365_("Abilities", (Tag)abilitiesList);
        nbt.m_128365_("ScheduledRefund", (Tag)scheduledRefund);
        nbt.m_128365_("ScheduledCorruptionCheck", (Tag)scheduledCorruptionCheck);
        return nbt;
    }

    private void migrate(CompoundTag nbt) {
        if (this.version == -1) {
            ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
            for (int i = 0; i < playerList.size(); ++i) {
                this.scheduledRefund.add(UUID.fromString(playerList.m_128778_(i)));
            }
            ++this.version;
        }
        if (this.version == 0) {
            this.playerMap.forEach((uuid, tree) -> this.scheduledCorruptionCheck.add((UUID)uuid));
            ++this.version;
        }
    }

    private static PlayerAbilitiesData create(CompoundTag tag) {
        PlayerAbilitiesData data = new PlayerAbilitiesData();
        data.load(tag);
        return data;
    }

    public static PlayerAbilitiesData get(ServerLevel world) {
        return PlayerAbilitiesData.get(world.m_142572_());
    }

    public static PlayerAbilitiesData get(MinecraftServer srv) {
        return (PlayerAbilitiesData)srv.m_129783_().m_8895_().m_164861_(PlayerAbilitiesData::create, PlayerAbilitiesData::new, DATA_NAME);
    }
}

