/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.skill.archetype.ArchetypeContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerArchetypeData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerArchetype";
    private final Map<UUID, ArchetypeContainer> playerMap = new HashMap<UUID, ArchetypeContainer>();
    private static final String TAG_PLAYER_LIST = "playerList";
    private static final String TAG_ARCHETYPE_LIST = "archetypeList";

    public static PlayerArchetypeData get(ServerLevel level) {
        return PlayerArchetypeData.get(level.m_142572_());
    }

    public static PlayerArchetypeData get(MinecraftServer server) {
        return (PlayerArchetypeData)server.m_129783_().m_8895_().m_164861_(PlayerArchetypeData::create, PlayerArchetypeData::new, DATA_NAME);
    }

    private static PlayerArchetypeData create(CompoundTag compoundTag) {
        return new PlayerArchetypeData(compoundTag);
    }

    private PlayerArchetypeData() {
    }

    private PlayerArchetypeData(CompoundTag compoundTag) {
        this();
        this.load(compoundTag);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side.isServer() && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerArchetypeData.get(player2.f_8924_).getArchetypeContainer((Player)player2).tick(player2.f_8924_, player2);
        }
    }

    public ArchetypeContainer getArchetypeContainer(Player player) {
        return this.getArchetypeContainer(player.m_142081_());
    }

    public ArchetypeContainer getArchetypeContainer(UUID playerUuid) {
        return this.playerMap.computeIfAbsent(playerUuid, ArchetypeContainer::new);
    }

    public PlayerArchetypeData set(ServerPlayer player, ResourceLocation id) {
        this.getArchetypeContainer((Player)player).setCurrentArchetype(player.m_20194_(), id);
        this.m_77762_();
        return this;
    }

    private void load(CompoundTag compoundTag) {
        ListTag playerList = compoundTag.m_128437_(TAG_PLAYER_LIST, 8);
        ListTag archetypeList = compoundTag.m_128437_(TAG_ARCHETYPE_LIST, 10);
        if (playerList.size() != archetypeList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getArchetypeContainer(playerUUID).deserializeNBT(archetypeList.m_128728_(i));
        }
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag playerList = new ListTag();
        ListTag archetypeList = new ListTag();
        this.playerMap.forEach((key, value) -> {
            playerList.add((Object)StringTag.m_129297_((String)key.toString()));
            archetypeList.add((Object)value.serializeNBT());
        });
        compoundTag.m_128365_(TAG_PLAYER_LIST, (Tag)playerList);
        compoundTag.m_128365_(TAG_ARCHETYPE_LIST, (Tag)archetypeList);
        return compoundTag;
    }
}

