/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.etching.EtchingHelper;
import iskallia.vault.etching.EtchingRegistry;
import iskallia.vault.etching.EtchingSet;
import iskallia.vault.util.NetcodeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerEtchingData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerEtchings";
    private final Map<UUID, List<EtchingSet<?>>> equippedEtchingSets = new HashMap();

    private PlayerEtchingData() {
    }

    private PlayerEtchingData(CompoundTag tag) {
        this.load(tag);
    }

    public List<EtchingSet<?>> getEtchingSets(Player player) {
        return this.getEtchingSets(player.m_142081_());
    }

    private List<EtchingSet<?>> getEtchingSets(UUID playerId) {
        return this.equippedEtchingSets.getOrDefault(playerId, new ArrayList());
    }

    public void tick(MinecraftServer srv) {
        this.equippedEtchingSets.forEach((playerId, etchingSets) -> NetcodeUtils.runIfPresent(srv, playerId, sPlayer -> etchingSets.forEach(set -> set.tick((ServerPlayer)sPlayer))));
    }

    public void refreshEtchingSets(ServerPlayer player) {
        List knownEtchings = this.equippedEtchingSets.computeIfAbsent(player.m_142081_(), id -> new ArrayList());
        List<EtchingSet<?>> foundEtchings = EtchingHelper.getEquippedEtchings((LivingEntity)player);
        knownEtchings.removeIf(existingSet -> {
            if (!foundEtchings.contains(existingSet)) {
                existingSet.remove(player);
                return true;
            }
            return false;
        });
        foundEtchings.forEach(newSet -> {
            if (!knownEtchings.contains(newSet)) {
                newSet.apply(player);
                knownEtchings.add(newSet);
            }
        });
    }

    protected void load(CompoundTag tag) {
        this.equippedEtchingSets.clear();
        ListTag playerEtchings = tag.m_128437_("players", 10);
        for (int i = 0; i < playerEtchings.size(); ++i) {
            CompoundTag playerTag = playerEtchings.m_128728_(i);
            UUID playerId = playerTag.m_128342_("id");
            ArrayList etchingSets = new ArrayList();
            ListTag etchings = tag.m_128437_("etchings", 8);
            for (int j = 0; j < etchings.size(); ++j) {
                ResourceLocation etchingKey = new ResourceLocation(etchings.m_128778_(j));
                EtchingSet<?> set = EtchingRegistry.getEtchingSet(etchingKey);
                if (set == null) continue;
                etchingSets.add(set);
            }
            this.equippedEtchingSets.put(playerId, etchingSets);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag playerEtchings = new ListTag();
        this.equippedEtchingSets.forEach((playerId, etchingSets) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("id", playerId);
            ListTag etchings = new ListTag();
            etchingSets.forEach(set -> etchings.add((Object)StringTag.m_129297_((String)set.getRegistryName().toString())));
            playerTag.m_128365_("etchings", (Tag)etchings);
            playerEtchings.add((Object)playerTag);
        });
        tag.m_128365_("players", (Tag)playerEtchings);
        return tag;
    }

    public static PlayerEtchingData get(ServerLevel world) {
        return PlayerEtchingData.get(world.m_142572_());
    }

    public static PlayerEtchingData get(MinecraftServer server) {
        return (PlayerEtchingData)server.m_129783_().m_8895_().m_164861_(PlayerEtchingData::new, PlayerEtchingData::new, DATA_NAME);
    }
}

