/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerExpertisesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerExpertises";
    private Map<UUID, ExpertiseTree> playerMap = new HashMap<UUID, ExpertiseTree>();
    private final Set<UUID> scheduledMerge = new HashSet<UUID>();
    private ExpertiseTree previous;

    public ExpertiseTree getExpertises(Player player) {
        return this.getExpertises(player.m_142081_());
    }

    public ExpertiseTree getExpertises(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, uuid1 -> (ExpertiseTree)ModConfigs.EXPERTISES.getAll().copy());
    }

    public void resetAllPlayerExpertiseTrees(ServerLevel level) {
        this.playerMap.clear();
        this.m_77762_();
        for (ServerPlayer player : level.m_6907_()) {
            this.getExpertises((Player)player).sync(SkillContext.of(player));
        }
    }

    public PlayerExpertisesData resetExpertiseTree(ServerPlayer player) {
        this.getExpertises((Player)player).iterate(LearnableSkill.class, skill -> skill.onRemove(SkillContext.of(player)));
        this.playerMap.remove(player.m_142081_());
        this.m_77762_();
        this.getExpertises((Player)player).sync(SkillContext.of(player));
        return this;
    }

    public boolean m_77764_() {
        return true;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer()) {
            PlayerExpertisesData data = PlayerExpertisesData.get((ServerLevel)event.world);
            if (data.previous != ModConfigs.EXPERTISES.getAll()) {
                data.previous = ModConfigs.EXPERTISES.getAll();
                data.scheduledMerge.addAll(data.playerMap.keySet());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer() && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerExpertisesData data = PlayerExpertisesData.get(player2.m_183503_());
            if (data.scheduledMerge.remove(player2.m_142081_())) {
                SkillContext context = SkillContext.of(player2);
                data.playerMap.get(player2.m_142081_()).mergeFrom((Skill)ModConfigs.EXPERTISES.getAll().copy(), context);
                PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player2.f_19853_).getVaultStats((Player)player2);
                stats.setSkillPoints(context.getLearnPoints());
                stats.setRegretPoints(context.getRegretPoints());
                AttributeSnapshotHelper.getInstance().refreshSnapshotDelayed(player2);
            }
            data.getExpertises((Player)player2).onTick(SkillContext.of(player2));
        }
    }

    private static PlayerExpertisesData create(CompoundTag tag) {
        PlayerExpertisesData data = new PlayerExpertisesData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.playerMap.clear();
        this.scheduledMerge.clear();
        ListTag playerList = nbt.m_128437_("Players", 8);
        ListTag talentList = nbt.m_128437_("Expertises", 10);
        if (playerList.size() != talentList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            Adapters.SKILL.readNbt((Tag)talentList.m_128728_(i)).ifPresent(tree -> {
                this.playerMap.put(playerUUID, (ExpertiseTree)tree);
                this.scheduledMerge.add(playerUUID);
            });
        }
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag talentList = new ListTag();
        this.playerMap.forEach((uuid, researchTree) -> Adapters.SKILL.writeNbt(researchTree).ifPresent(tag -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            talentList.add(tag);
        }));
        nbt.m_128365_("Players", (Tag)playerList);
        nbt.m_128365_("Expertises", (Tag)talentList);
        return nbt;
    }

    public static PlayerExpertisesData getServer() {
        return PlayerExpertisesData.get(ServerLifecycleHooks.getCurrentServer());
    }

    public static PlayerExpertisesData get(ServerLevel world) {
        return PlayerExpertisesData.get(world.m_142572_());
    }

    public static PlayerExpertisesData get(MinecraftServer srv) {
        return (PlayerExpertisesData)srv.m_129783_().m_8895_().m_164861_(PlayerExpertisesData::create, PlayerExpertisesData::new, DATA_NAME);
    }
}

